/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassEscapesItsScopeInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean checkModuleApi = true;
    public boolean checkPublicApi;
    public boolean checkPackageLocal;

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "ClassEscapesDefinedScope";
    }

    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("class.escapes.defined.scope.display.name", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("class.escapes.defined.scope.display.module.option", new Object[0]), "checkModuleApi");
        panel.addCheckbox(InspectionGadgetsBundle.message("class.escapes.defined.scope.display.public.option", new Object[0]), "checkPublicApi");
        panel.addCheckbox(InspectionGadgetsBundle.message("class.escapes.defined.scope.display.package.option", new Object[0]), "checkPackageLocal");
        return panel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        THashSet exportedPackageNames;
        Module module;
        VirtualFile vFile;
        PsiJavaModule psiModule;
        PsiJavaFile javaFile;
        PsiFile file;
        ArrayList<VisibilityChecker> checkers = new ArrayList<VisibilityChecker>(2);
        if (this.checkModuleApi && (file = holder.getFile()) instanceof PsiJavaFile && (javaFile = (PsiJavaFile)file).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) && (psiModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)file)) != null && (vFile = file.getVirtualFile()) != null && (module = ProjectFileIndex.SERVICE.getInstance((Project)holder.getProject()).getModuleForFile(vFile)) != null && (exportedPackageNames = new THashSet((Collection)ContainerUtil.mapNotNull((Iterable)psiModule.getExports(), PsiPackageAccessibilityStatement::getPackageName))).contains(javaFile.getPackageName())) {
            checkers.add(new Java9NonAccessibleTypeExposedVisitor(holder, module, psiModule.getName(), (Set<String>)exportedPackageNames));
        }
        if (this.checkPublicApi || this.checkPackageLocal) {
            checkers.add(new ClassEscapesItsScopeVisitor(holder));
        }
        return !checkers.isEmpty() ? new VisibilityVisitor(checkers.toArray(VisibilityChecker.EMPTY_ARRAY)) : PsiElementVisitor.EMPTY_VISITOR;
    }

    private static class Java9NonAccessibleTypeExposedVisitor
    extends VisibilityChecker {
        private final ModuleFileIndex myModuleFileIndex;
        private final Set<String> myExportedPackageNames;
        private final String myModuleName;

        Java9NonAccessibleTypeExposedVisitor(@NotNull ProblemsHolder holder, @NotNull Module module, @NotNull String moduleName, @NotNull Set<String> exportedPackageNames) {
            super(holder);
            this.myModuleName = moduleName;
            this.myModuleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
            this.myExportedPackageNames = exportedPackageNames;
        }

        @Override
        public boolean checkVisibilityIssue(PsiMember member, PsiClass psiClass, PsiJavaCodeReferenceElement reference) {
            if (this.isModulePublicApi(member) && !this.isModulePublicApi((PsiMember)psiClass) && this.isInModuleSource(psiClass)) {
                this.myHolder.registerProblem((PsiElement)reference, InspectionGadgetsBundle.message("class.escapes.defined.scope.java9.modules.descriptor", this.myModuleName), new LocalQuickFix[0]);
                return true;
            }
            return false;
        }

        @Contract(value="null -> false")
        private boolean isModulePublicApi(@Nullable PsiMember member) {
            if (member != null && !(member instanceof PsiTypeParameter) && (member.hasModifierProperty("public") || member.hasModifierProperty("protected"))) {
                PsiElement parent = member.getParent();
                if (parent instanceof PsiClass) {
                    return this.isModulePublicApi((PsiMember)((PsiClass)parent));
                }
                if (parent instanceof PsiJavaFile) {
                    String packageName = ((PsiJavaFile)parent).getPackageName();
                    return this.myExportedPackageNames.contains(packageName);
                }
            }
            return false;
        }

        private boolean isInModuleSource(@NotNull PsiClass psiClass) {
            VirtualFile vFile;
            PsiFile psiFile = psiClass.getContainingFile();
            if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
                return this.myModuleFileIndex.isInSourceContent(vFile);
            }
            return false;
        }
    }

    private class ClassEscapesItsScopeVisitor
    extends VisibilityChecker {
        ClassEscapesItsScopeVisitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        boolean checkVisibilityIssue(PsiMember member, PsiClass psiClass, PsiJavaCodeReferenceElement reference) {
            if (this.needToCheck(member) && this.isLessRestrictiveScope(member, psiClass)) {
                this.myHolder.registerProblem((PsiElement)reference, InspectionGadgetsBundle.message("class.escapes.defined.scope.problem.descriptor", new Object[0]), new LocalQuickFix[0]);
                return true;
            }
            return false;
        }

        private boolean needToCheck(PsiMember member) {
            return ClassEscapesItsScopeInspection.this.checkPublicApi && (member.hasModifierProperty("public") || member.hasModifierProperty("protected")) || ClassEscapesItsScopeInspection.this.checkPackageLocal && member.hasModifierProperty("packageLocal");
        }

        private boolean isLessRestrictiveScope(@NotNull PsiMember member, @NotNull PsiClass aClass) {
            int methodScopeOrder = this.getScopeOrder((PsiModifierListOwner)member);
            int classScopeOrder = this.getScopeOrder((PsiModifierListOwner)aClass);
            PsiClass containingClass = member.getContainingClass();
            if (containingClass == null || containingClass.getQualifiedName() == null) {
                return false;
            }
            int containingClassScopeOrder = this.getScopeOrder((PsiModifierListOwner)containingClass);
            return methodScopeOrder > classScopeOrder && containingClassScopeOrder > classScopeOrder;
        }

        private int getScopeOrder(@NotNull PsiModifierListOwner element) {
            if (element.hasModifierProperty("public")) {
                return 4;
            }
            if (element.hasModifierProperty("private")) {
                return 1;
            }
            if (element.hasModifierProperty("protected")) {
                return 3;
            }
            return 2;
        }
    }

    private static abstract class VisibilityChecker {
        static final VisibilityChecker[] EMPTY_ARRAY = new VisibilityChecker[0];
        final ProblemsHolder myHolder;

        protected VisibilityChecker(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        abstract boolean checkVisibilityIssue(PsiMember var1, PsiClass var2, PsiJavaCodeReferenceElement var3);
    }

    private static class VisibilityVisitor
    extends JavaElementVisitor {
        private final VisibilityChecker[] myCheckers;

        VisibilityVisitor(VisibilityChecker[] checkers) {
            this.myCheckers = checkers;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            PsiElement resolved;
            PsiMember member;
            PsiElement grandParent;
            super.visitReferenceElement(reference);
            PsiElement parent = reference.getParent();
            if ((parent instanceof PsiTypeElement || parent instanceof PsiReferenceList) && ((grandParent = PsiTreeUtil.skipParentsOfType((PsiElement)reference, (Class[])new Class[]{PsiTypeElement.class, PsiReferenceList.class, PsiParameter.class, PsiParameterList.class, PsiReferenceParameterList.class, PsiJavaCodeReferenceElement.class, PsiTypeParameter.class, PsiTypeParameterList.class})) instanceof PsiField || grandParent instanceof PsiMethod) && !VisibilityVisitor.isPrivate(member = (PsiMember)grandParent) && (resolved = reference.resolve()) instanceof PsiClass && !(resolved instanceof PsiTypeParameter)) {
                PsiClass psiClass = (PsiClass)resolved;
                for (VisibilityChecker checker : this.myCheckers) {
                    if (!checker.checkVisibilityIssue(member, psiClass, reference)) continue;
                    return;
                }
            }
        }

        private static boolean isPrivate(@NotNull PsiMember member) {
            if (member.hasModifierProperty("private")) {
                return true;
            }
            PsiClass containingClass = member.getContainingClass();
            return containingClass != null && VisibilityVisitor.isPrivate((PsiMember)containingClass);
        }
    }
}

