/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class MethodOverridesStaticMethodInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @NotNull
    public String getID() {
        return "MethodOverridesStaticMethodOfSuperclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("method.overrides.static.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("method.overrides.static.problem.descriptor", new Object[0]);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodOverridesStaticMethodVisitor();
    }

    private static class MethodOverridesStaticMethodVisitor
    extends BaseInspectionVisitor {
        private MethodOverridesStaticMethodVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod[] methods;
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (method.getNameIdentifier() == null || !method.hasModifierProperty("static")) {
                return;
            }
            PsiClass ancestorClass = aClass.getSuperClass();
            if (ancestorClass == null) {
                return;
            }
            for (PsiMethod testMethod : methods = ancestorClass.findMethodsBySignature(method, true)) {
                if (!testMethod.hasModifierProperty("static") || testMethod.hasModifierProperty("private")) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }
    }
}

