/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.bool.ConjunctionPredicate;
import org.jetbrains.annotations.NotNull;

public class DemorgansIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.ANDAND)) {
            return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"&&", "||"});
        }
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{"||", "&&"});
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ConjunctionPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element;
        CommentTracker tracker = new CommentTracker();
        String newExpression = DemorgansIntention.convertConjunctionExpression(polyadicExpression, tracker);
        DemorgansIntention.replaceExpressionWithNegatedExpressionString(newExpression, (PsiExpression)polyadicExpression, tracker);
    }

    private static String convertConjunctionExpression(PsiPolyadicExpression polyadicExpression, CommentTracker tracker) {
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        boolean tokenTypeAndAnd = tokenType.equals(JavaTokenType.ANDAND);
        String flippedConjunction = tokenTypeAndAnd ? "||" : "&&";
        StringBuilder result = new StringBuilder();
        for (PsiExpression operand2 : polyadicExpression.getOperands()) {
            if (result.length() != 0) {
                result.append(flippedConjunction);
            }
            result.append(DemorgansIntention.convertLeafExpression(operand2, tokenTypeAndAnd, tracker));
        }
        return result.toString();
    }

    private static String convertLeafExpression(PsiExpression expression2, boolean tokenTypeAndAnd, CommentTracker tracker) {
        if (BoolUtils.isNegation(expression2)) {
            PsiExpression negatedExpression = BoolUtils.getNegated(expression2);
            if (negatedExpression == null) {
                return "";
            }
            return tracker.text(negatedExpression, tokenTypeAndAnd ? 14 : 13);
        }
        if (ComparisonUtils.isComparison(expression2)) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression2;
            String negatedComparison = ComparisonUtils.getNegatedComparison(binaryExpression.getOperationTokenType());
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            assert (rhs != null);
            return tracker.text((PsiElement)lhs) + negatedComparison + tracker.text((PsiElement)rhs);
        }
        return '!' + tracker.text(expression2, 3);
    }
}

