/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.collections;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.dataFlow.NullabilityUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ReplaceWithArraysAsListIntention
extends Intention
implements HighPriorityAction {
    private String replacementText = null;

    @Override
    @NotNull
    public String getText() {
        return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.replacementText + "()"});
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return e -> {
            if (!(e instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)e;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return false;
            }
            String qualifiedName = aClass.getQualifiedName();
            if (qualifiedName == null || !qualifiedName.equals("java.util.Collections")) {
                return false;
            }
            String name = method.getName();
            this.replacementText = ReplaceWithArraysAsListIntention.getReplacementMethodText(name, methodCallExpression);
            return this.replacementText != null;
        };
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = methodCallExpression.getArgumentList();
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiReferenceParameterList parameterList = methodExpression.getParameterList();
        CommentTracker commentTracker = new CommentTracker();
        if (parameterList != null) {
            int dotIndex = this.replacementText.lastIndexOf(46) + 1;
            this.replacementText = this.replacementText.substring(0, dotIndex) + commentTracker.text((PsiElement)parameterList) + this.replacementText.substring(dotIndex);
        }
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)methodCallExpression, this.replacementText + commentTracker.text((PsiElement)argumentList), commentTracker);
    }

    private static String getReplacementMethodText(String methodName, PsiMethodCallExpression context) {
        PsiExpression[] arguments = context.getArgumentList().getExpressions();
        if (methodName.equals("emptyList") && arguments.length == 1 && !PsiUtil.isLanguageLevel9OrHigher((PsiElement)context) && ClassUtils.findClass("com.google.common.collect.ImmutableList", (PsiElement)context) == null) {
            return "java.util.Collections.singletonList";
        }
        if (methodName.equals("emptyList") || methodName.equals("singletonList")) {
            if (Arrays.stream(arguments).noneMatch(ReplaceWithArraysAsListIntention::isPossiblyNull)) {
                if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)context)) {
                    return "java.util.List.of";
                }
                if (ClassUtils.findClass("com.google.common.collect.ImmutableList", (PsiElement)context) != null) {
                    return "com.google.common.collect.ImmutableList.of";
                }
            }
            return "java.util.Arrays.asList";
        }
        if (methodName.equals("emptySet") || methodName.equals("singleton")) {
            if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)context)) {
                return "java.util.Set.of";
            }
            if (ClassUtils.findClass("com.google.common.collect.ImmutableSet", (PsiElement)context) != null) {
                return "com.google.common.collect.ImmutableSet.of";
            }
        } else if (methodName.equals("emptyMap") || methodName.equals("singletonMap")) {
            if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)context)) {
                return "java.util.Map.of";
            }
            if (ClassUtils.findClass("com.google.common.collect.ImmutableMap", (PsiElement)context) != null) {
                return "com.google.common.collect.ImmutableMap.of";
            }
        }
        return null;
    }

    private static boolean isPossiblyNull(PsiExpression expression2) {
        return NullabilityUtil.getExpressionNullability(expression2) == Nullability.NULLABLE;
    }
}

