/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.SmartList;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.StringConcatPredicate;
import org.jetbrains.annotations.NotNull;

public class JoinConcatenatedStringLiteralsIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new StringConcatPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
        }
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        PsiJavaToken token = (PsiJavaToken)element;
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        StringBuilder newExpression = new StringBuilder();
        PsiElement[] children = polyadicExpression.getChildren();
        SmartList buffer = new SmartList();
        for (PsiElement child : children) {
            Object value2;
            PsiLiteralExpression literalExpression;
            if (child instanceof PsiJavaToken) {
                if (token.equals(child)) {
                    literalExpression = (PsiLiteralExpression)buffer.get(0);
                    value2 = literalExpression.getValue();
                    assert (value2 != null);
                    newExpression.append('\"').append(StringUtil.escapeStringCharacters((String)value2.toString()));
                    continue;
                }
                for (PsiElement bufferedElement : buffer) {
                    newExpression.append(bufferedElement.getText());
                }
                buffer.clear();
                newExpression.append(child.getText());
                continue;
            }
            if (child instanceof PsiLiteralExpression) {
                if (buffer.isEmpty()) {
                    buffer.add(child);
                    continue;
                }
                literalExpression = (PsiLiteralExpression)child;
                value2 = literalExpression.getValue();
                assert (value2 != null);
                newExpression.append(StringUtil.escapeStringCharacters((String)value2.toString())).append('\"');
                buffer.clear();
                continue;
            }
            if (buffer.isEmpty()) {
                newExpression.append(tracker.text(child));
                continue;
            }
            buffer.add(child);
        }
        for (PsiElement bufferedElement : buffer) {
            newExpression.append(tracker.text(bufferedElement));
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpression.toString(), tracker);
    }
}

