/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.MethodCallChainPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakeCallChainIntoCallSequenceIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new MethodCallChainPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiLocalVariable variable;
        PsiType variableType;
        ArrayList<String> callTexts = new ArrayList<String>();
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element, PsiMethodCallExpression.class);
        if (call == null) {
            return;
        }
        if ((call = RefactoringUtil.ensureCodeBlock(call)) == null) {
            return;
        }
        PsiStatement appendStatement = (PsiStatement)ObjectUtils.tryCast((Object)RefactoringUtil.getParentStatement((PsiElement)call, false), PsiStatement.class);
        if (appendStatement == null) {
            return;
        }
        PsiMethodCallExpression toReplace = call;
        PsiExpression root = MethodCallChainPredicate.getCallChainRoot((PsiElement)call);
        if (root == null) {
            return;
        }
        PsiType callType = call.getType();
        if (callType == null) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        while (call != null && call != root) {
            callTexts.add(call.getMethodExpression().getReferenceName() + tracker.text((PsiElement)call.getArgumentList()));
            call = MethodCallUtils.getQualifierMethodCall(call);
        }
        PsiType rootType = root.getType();
        if (rootType == null) {
            return;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)toReplace.getParent());
        String targetText = "x";
        boolean introduceVariable = true;
        boolean keepLastStatement = true;
        String variableText = rootType.getCanonicalText() + ' ' + targetText + '=' + root.getText() + ';';
        String firstStatement = (JavaCodeStyleSettings.getInstance((PsiFile)toReplace.getContainingFile()).GENERATE_FINAL_LOCALS ? "final " : "") + variableText;
        if (MakeCallChainIntoCallSequenceIntention.isSimpleReference(root)) {
            targetText = root.getText();
            firstStatement = null;
            introduceVariable = false;
        } else if (parent instanceof PsiAssignmentExpression && parent.getParent() instanceof PsiExpressionStatement && ((PsiAssignmentExpression)parent).getOperationTokenType().equals(JavaTokenType.EQ)) {
            PsiVariable variable2;
            PsiType variableType2;
            PsiReferenceExpression expression2;
            PsiElement target;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression());
            if (lhs instanceof PsiReferenceExpression && (target = (expression2 = (PsiReferenceExpression)lhs).resolve()) instanceof PsiVariable && (variableType2 = (variable2 = (PsiVariable)target).getType()).equals(rootType)) {
                targetText = tracker.text((PsiElement)lhs);
                firstStatement = targetText + '=' + root.getText() + ';';
                introduceVariable = false;
                keepLastStatement = false;
            }
        } else if (parent instanceof PsiLocalVariable && (variableType = (variable = (PsiLocalVariable)parent).getType()).equals(rootType)) {
            targetText = variable.getName();
            PsiLocalVariable varCopy = (PsiLocalVariable)variable.copy();
            varCopy.setInitializer(root);
            firstStatement = varCopy.getText();
            introduceVariable = false;
            keepLastStatement = false;
        }
        if (parent instanceof PsiExpressionStatement) {
            keepLastStatement = false;
        }
        if (keepLastStatement && !callType.equals(rootType)) {
            callTexts.remove(0);
            toReplace = Objects.requireNonNull(toReplace.getMethodExpression().getQualifierExpression());
        }
        String replacementBlock = MakeCallChainIntoCallSequenceIntention.generateReplacementBlock(callTexts, targetText, firstStatement);
        PsiElement appendStatementParent = appendStatement.getParent();
        PsiVariable variable3 = MakeCallChainIntoCallSequenceIntention.appendStatements(appendStatement, tracker, introduceVariable, replacementBlock);
        if (keepLastStatement) {
            tracker.replaceAndRestoreComments((PsiElement)toReplace, targetText);
        } else {
            tracker.deleteAndRestoreComments((PsiElement)appendStatement);
        }
        if (variable3 != null) {
            HighlightUtil.showRenameTemplate(appendStatementParent, (PsiNameIdentifierOwner)variable3);
        }
    }

    @Nullable
    private static PsiVariable appendStatements(PsiStatement anchor, CommentTracker tracker, boolean introduceVariable, String replacementBlock) {
        PsiElement parent = anchor.getParent();
        Project project = anchor.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiBlockStatement codeBlock = (PsiBlockStatement)factory.createStatementFromText(replacementBlock, (PsiElement)anchor);
        PsiStatement[] statements = codeBlock.getCodeBlock().getStatements();
        PsiVariable variable = null;
        int length = statements.length;
        for (int i = 0; i < length; ++i) {
            PsiElement insertedStatement = parent.addBefore((PsiElement)tracker.markUnchanged(statements[i]), (PsiElement)anchor);
            if (i == 0 && introduceVariable) {
                variable = (PsiVariable)((PsiDeclarationStatement)insertedStatement).getDeclaredElements()[0];
            }
            codeStyleManager.reformat(insertedStatement);
        }
        return variable;
    }

    @NotNull
    private static String generateReplacementBlock(List<String> calls, String target, String firstStatement) {
        StringBuilder builder = new StringBuilder("{\n");
        if (firstStatement != null) {
            builder.append(firstStatement);
        }
        Collections.reverse(calls);
        for (String callText : calls) {
            builder.append(target).append('.').append(callText).append(";\n");
        }
        builder.append('}');
        return builder.toString();
    }

    @Contract(value="null -> false")
    private static boolean isSimpleReference(PsiExpression expression2) {
        if (!(expression2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)expression2;
        PsiExpression qualifier = ref.getQualifierExpression();
        if (!(qualifier == null || qualifier instanceof PsiQualifiedExpression && ((PsiQualifiedExpression)qualifier).getQualifier() == null)) {
            return false;
        }
        return ref.resolve() instanceof PsiVariable;
    }
}

