/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConditionalWithBooleanExpressionIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof PsiConditionalExpression)) {
                    return false;
                }
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
                PsiType type2 = conditionalExpression.getType();
                return PsiType.BOOLEAN.equals((Object)type2) || type2 != null && type2.equalsToText("java.lang.Boolean");
            }
        };
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
        PsiExpression condition2 = conditionalExpression.getCondition();
        CommentTracker tracker = new CommentTracker();
        String replacementText = condition2.getText() + "&&" + ReplaceConditionalWithBooleanExpressionIntention.getText(conditionalExpression.getThenExpression(), tracker) + "||" + BoolUtils.getNegatedExpressionText(condition2, 13, tracker) + "&&" + ReplaceConditionalWithBooleanExpressionIntention.getText(conditionalExpression.getElseExpression(), tracker);
        PsiReplacementUtil.replaceExpression((PsiExpression)element, replacementText, tracker);
    }

    private static String getText(@Nullable PsiExpression expression2, CommentTracker tracker) {
        if (expression2 == null) {
            return "";
        }
        return tracker.text(expression2, 13);
    }
}

