/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.DetailExceptionsPredicate;
import com.siyeh.ipp.exceptions.HierarchicalTypeComparator;
import com.siyeh.ipp.exceptions.ObscureThrownExceptionsIntention;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DetailExceptionsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new DetailExceptionsPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiCatchSection[] catchSections;
        PsiCodeBlock tryBlock;
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class);
        if (tryStatement == null) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        StringBuilder newTryStatement = new StringBuilder("try");
        HashSet<PsiClassType> exceptionsThrown = new HashSet<PsiClassType>();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            newTryStatement.append(commentTracker.text((PsiElement)resourceList));
            ExceptionUtils.calculateExceptionsThrown((PsiElement)resourceList, exceptionsThrown);
        }
        if ((tryBlock = tryStatement.getTryBlock()) == null) {
            return;
        }
        String tryBlockText = commentTracker.text((PsiElement)tryBlock);
        newTryStatement.append(tryBlockText);
        ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock, exceptionsThrown);
        HierarchicalTypeComparator comparator = new HierarchicalTypeComparator();
        for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
            PsiParameter parameter2 = catchSection.getParameter();
            PsiCodeBlock block = catchSection.getCatchBlock();
            if (parameter2 == null || block == null) continue;
            PsiType caughtType = parameter2.getType();
            List<Object> exceptionsToExpand = new ArrayList<PsiClassType>(exceptionsThrown.size());
            for (PsiClassType aExceptionsThrown : exceptionsThrown) {
                if (!caughtType.isAssignableFrom((PsiType)aExceptionsThrown)) continue;
                exceptionsToExpand.add(aExceptionsThrown);
            }
            exceptionsThrown.removeAll(exceptionsToExpand);
            PsiClassType commonSuperType = null;
            PsiClass commonSuper = ObscureThrownExceptionsIntention.findCommonSuperClass(exceptionsToExpand.toArray(PsiClassType.EMPTY_ARRAY));
            if (commonSuper != null && (commonSuperType = JavaPsiFacade.getElementFactory((Project)commonSuper.getProject()).createType(commonSuper)).equals((Object)caughtType)) {
                commonSuperType = null;
            }
            if (commonSuperType != null) {
                exceptionsToExpand = Collections.singletonList(commonSuperType);
            } else {
                Collections.sort(exceptionsToExpand, comparator);
            }
            for (PsiClassType psiClassType : exceptionsToExpand) {
                newTryStatement.append("catch(").append(psiClassType.getCanonicalText()).append(' ').append(parameter2.getName()).append(')');
                newTryStatement.append(commentTracker.text((PsiElement)block));
            }
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            newTryStatement.append("finally").append(commentTracker.text((PsiElement)finallyBlock));
        }
        String newStatement = newTryStatement.toString();
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)tryStatement, newStatement, commentTracker);
    }
}

