/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.IterableForEachLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceForEachLoopWithIteratorForLoopIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new IterableForEachLoopPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiForeachStatement statement = (PsiForeachStatement)element.getParent();
        if (statement == null) {
            return;
        }
        PsiExpression iteratedValue2 = statement.getIteratedValue();
        if (iteratedValue2 == null) {
            return;
        }
        PsiType iteratedValueType = iteratedValue2.getType();
        if (!(iteratedValueType instanceof PsiClassType)) {
            return;
        }
        CommentTracker tracker = new CommentTracker();
        String methodCall = tracker.text(iteratedValue2, 1) + ".iterator()";
        Project project = statement.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression iteratorCall = factory.createExpressionFromText(methodCall, (PsiElement)iteratedValue2);
        PsiType variableType = GenericsUtil.getVariableTypeByExpressionType((PsiType)iteratorCall.getType());
        if (variableType == null) {
            return;
        }
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("for(").append(variableType.getCanonicalText()).append(' ');
        String iterator = new VariableNameGenerator((PsiElement)statement, VariableKind.LOCAL_VARIABLE).byName("iterator", "iter", "it").generate(true);
        newStatement.append(iterator).append("=").append(iteratorCall.getText()).append(';');
        newStatement.append(iterator).append(".hasNext();) {");
        if (JavaCodeStyleSettings.getInstance((PsiFile)statement.getContainingFile()).GENERATE_FINAL_LOCALS) {
            newStatement.append("final ");
        }
        PsiParameter iterationParameter = statement.getIterationParameter();
        PsiType parameterType = iterationParameter.getType();
        String typeText = parameterType.getCanonicalText();
        newStatement.append(typeText).append(' ').append(iterationParameter.getName()).append(" = ").append(iterator).append(".next();");
        PsiStatement body2 = statement.getBody();
        if (body2 == null) {
            return;
        }
        if (body2 instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)body2).getCodeBlock();
            PsiElement[] children = block.getChildren();
            for (int i = 1; i < children.length - 1; ++i) {
                newStatement.append(tracker.text(children[i]));
            }
        } else {
            newStatement.append(tracker.text((PsiElement)body2));
        }
        newStatement.append('}');
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newStatement.toString(), tracker);
    }
}

