/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.ReverseForLoopDirectionPredicate;
import org.jetbrains.annotations.NotNull;

public class ReverseForLoopDirectionIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ReverseForLoopDirectionPredicate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void processIntention(@NotNull PsiElement element) {
        IElementType tokenType;
        PsiForStatement forStatement = (PsiForStatement)element.getParent();
        PsiDeclarationStatement initialization = (PsiDeclarationStatement)forStatement.getInitialization();
        if (initialization == null) {
            return;
        }
        PsiBinaryExpression condition2 = (PsiBinaryExpression)forStatement.getCondition();
        if (condition2 == null) {
            return;
        }
        PsiLocalVariable variable = (PsiLocalVariable)initialization.getDeclaredElements()[0];
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return;
        }
        PsiExpression lhs = condition2.getLOperand();
        PsiExpression rhs = condition2.getROperand();
        if (rhs == null) {
            return;
        }
        PsiExpressionStatement update2 = (PsiExpressionStatement)forStatement.getUpdate();
        if (update2 == null) {
            return;
        }
        PsiExpression updateExpression = update2.getExpression();
        String variableName = variable.getName();
        StringBuilder newUpdateText = new StringBuilder();
        if (updateExpression instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)updateExpression;
            tokenType = prefixExpression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS == tokenType) {
                newUpdateText.append("--");
            } else {
                if (JavaTokenType.MINUSMINUS != tokenType) return;
                newUpdateText.append("++");
            }
            newUpdateText.append(variableName);
        } else {
            if (!(updateExpression instanceof PsiPostfixExpression)) return;
            newUpdateText.append(variableName);
            PsiPostfixExpression postfixExpression = (PsiPostfixExpression)updateExpression;
            tokenType = postfixExpression.getOperationTokenType();
            if (JavaTokenType.PLUSPLUS == tokenType) {
                newUpdateText.append("--");
            } else {
                if (JavaTokenType.MINUSMINUS != tokenType) return;
                newUpdateText.append("++");
            }
        }
        Project project = element.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        IElementType sign = condition2.getOperationTokenType();
        String negatedSign = ComparisonUtils.getNegatedComparison(sign);
        StringBuilder conditionText = new StringBuilder();
        StringBuilder newInitializerText = new StringBuilder();
        if (ExpressionUtils.isReferenceTo(lhs, (PsiVariable)variable)) {
            conditionText.append(variableName);
            conditionText.append(negatedSign);
            if (sign == JavaTokenType.GE) {
                conditionText.append(ReverseForLoopDirectionIntention.incrementExpression(initializer, true));
            } else if (sign == JavaTokenType.LE) {
                conditionText.append(ReverseForLoopDirectionIntention.incrementExpression(initializer, false));
            } else {
                conditionText.append(initializer.getText());
            }
            if (sign == JavaTokenType.LT) {
                newInitializerText.append(ReverseForLoopDirectionIntention.incrementExpression(rhs, false));
            } else if (sign == JavaTokenType.GT) {
                newInitializerText.append(ReverseForLoopDirectionIntention.incrementExpression(rhs, true));
            } else {
                newInitializerText.append(rhs.getText());
            }
        } else {
            if (!ExpressionUtils.isReferenceTo(rhs, (PsiVariable)variable)) return;
            if (sign == JavaTokenType.LE) {
                conditionText.append(ReverseForLoopDirectionIntention.incrementExpression(initializer, true));
            } else if (sign == JavaTokenType.GE) {
                conditionText.append(ReverseForLoopDirectionIntention.incrementExpression(initializer, false));
            } else {
                conditionText.append(initializer.getText());
            }
            conditionText.append(negatedSign);
            conditionText.append(variableName);
            if (sign == JavaTokenType.GT) {
                newInitializerText.append(ReverseForLoopDirectionIntention.incrementExpression(lhs, false));
            } else if (sign == JavaTokenType.LT) {
                newInitializerText.append(ReverseForLoopDirectionIntention.incrementExpression(lhs, true));
            } else {
                newInitializerText.append(lhs.getText());
            }
        }
        PsiExpression newInitializer = factory.createExpressionFromText(newInitializerText.toString(), element);
        variable.setInitializer(newInitializer);
        PsiExpression newCondition = factory.createExpressionFromText(conditionText.toString(), element);
        condition2.replace((PsiElement)newCondition);
        PsiExpression newUpdate = factory.createExpressionFromText(newUpdateText.toString(), element);
        updateExpression.replace((PsiElement)newUpdate);
    }

    private static String incrementExpression(PsiExpression expression2, boolean positive) {
        return JavaPsiMathUtil.add(expression2, positive ? 1 : -1, new CommentTracker());
    }
}

