/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.imports;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.ImportsUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.imports.OnDemandImportPredicate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ReplaceOnDemandImportIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new OnDemandImportPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiClass targetClass;
        PsiImportStatementBase importStatementBase = (PsiImportStatementBase)element;
        PsiJavaFile javaFile = (PsiJavaFile)importStatementBase.getContainingFile();
        PsiManager manager = importStatementBase.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        if (importStatementBase instanceof PsiImportStatement) {
            PsiImportStatement importStatement = (PsiImportStatement)importStatementBase;
            PsiClass[] classes2 = javaFile.getClasses();
            String qualifiedName = importStatement.getQualifiedName();
            ClassCollector visitor = new ClassCollector(qualifiedName);
            for (PsiClass aClass : classes2) {
                aClass.accept((PsiElementVisitor)visitor);
            }
            PsiClass[] importedClasses = visitor.getImportedClasses();
            Arrays.sort(importedClasses, new PsiClassComparator());
            ReplaceOnDemandImportIntention.createImportStatements((PsiImportStatementBase)importStatement, importedClasses, arg_0 -> ((PsiElementFactory)factory).createImportStatement(arg_0));
        } else if (importStatementBase instanceof PsiImportStaticStatement && (targetClass = ((PsiImportStaticStatement)importStatementBase).resolveTargetClass()) != null) {
            String[] members = (String[])ImportsUtil.collectReferencesThrough((PsiFile)javaFile, (PsiJavaCodeReferenceElement)importStatementBase.getImportReference(), (PsiImportStaticStatement)((PsiImportStaticStatement)importStatementBase)).stream().map(PsiReference::resolve).filter(resolve -> resolve instanceof PsiMember).map(member -> ((PsiMember)member).getName()).distinct().filter(Objects::nonNull).toArray(String[]::new);
            ReplaceOnDemandImportIntention.createImportStatements(importStatementBase, members, member -> factory.createImportStaticStatement(targetClass, member));
        }
    }

    private static <T> void createImportStatements(PsiImportStatementBase importStatement, T[] importedMembers, Function<T, PsiImportStatementBase> function) {
        PsiElement importList = importStatement.getParent();
        for (T importedMember : importedMembers) {
            importList.add((PsiElement)function.apply(importedMember));
        }
        new CommentTracker().deleteAndRestoreComments((PsiElement)importStatement);
    }

    private static final class PsiClassComparator
    implements Comparator<PsiClass> {
        private PsiClassComparator() {
        }

        @Override
        public int compare(PsiClass class1, PsiClass class2) {
            String qualifiedName1 = class1.getQualifiedName();
            String qualifiedName2 = class2.getQualifiedName();
            if (qualifiedName1 == null) {
                return -1;
            }
            return qualifiedName1.compareTo(qualifiedName2);
        }
    }

    private static class ClassCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final String importedPackageName;
        private final Set<PsiClass> importedClasses = new HashSet<PsiClass>();

        ClassCollector(String importedPackageName) {
            this.importedPackageName = importedPackageName;
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
            super.visitReferenceElement(reference);
            if (reference.isQualified()) {
                return;
            }
            PsiElement element = reference.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)element;
            String qualifiedName = aClass.getQualifiedName();
            String packageName = ClassUtil.extractPackageName((String)qualifiedName);
            if (!this.importedPackageName.equals(packageName)) {
                return;
            }
            this.importedClasses.add(aClass);
        }

        public PsiClass[] getImportedClasses() {
            return this.importedClasses.toArray(PsiClass.EMPTY_ARRAY);
        }
    }
}

