/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.increment;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.increment.IncrementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineIncrementIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        String operator2 = IncrementUtil.getOperatorText(element);
        return operator2 != null ? IntentionPowerPackBundle.message("inline.increment.intention.name", operator2) : null;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        Occurrence occurrence;
        PsiVariable variable;
        PsiReferenceExpression operandExpression = IncrementUtil.getIncrementOrDecrementOperand(element);
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)element.getParent(), PsiExpressionStatement.class);
        String operatorText = IncrementUtil.getOperatorText(element);
        if (operandExpression != null && expressionStatement != null && operatorText != null && (variable = InlineIncrementIntention.resolveSimpleVariableReference(operandExpression)) != null && (occurrence = InlineIncrementIntention.findSingleReadOccurrence(expressionStatement, variable)) != null) {
            Project project = expressionStatement.getProject();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            String text2 = occurrence.isPrevious ? occurrence.referenceExpression.getText() + operatorText : operatorText + occurrence.referenceExpression.getText();
            PsiExpression incrementOrDecrement = factory.createExpressionFromText(text2, (PsiElement)expressionStatement);
            incrementOrDecrement = (PsiExpression)occurrence.referenceExpression.replace((PsiElement)incrementOrDecrement);
            CodeStyleManager codeStyle = CodeStyleManager.getInstance((Project)project);
            codeStyle.reformat((PsiElement)incrementOrDecrement, true);
            CommentTracker ct = new CommentTracker();
            ct.deleteAndRestoreComments((PsiElement)expressionStatement);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return InlineIncrementIntention::isApplicableTo;
    }

    private static boolean isApplicableTo(PsiElement element) {
        PsiVariable variable;
        PsiReferenceExpression operandExpression = IncrementUtil.getIncrementOrDecrementOperand(element);
        PsiExpressionStatement expressionStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)element.getParent(), PsiExpressionStatement.class);
        return operandExpression != null && expressionStatement != null && (variable = InlineIncrementIntention.resolveSimpleVariableReference(operandExpression)) != null && InlineIncrementIntention.findSingleReadOccurrence(expressionStatement, variable) != null;
    }

    @Nullable
    @Contract(value="_, null -> null")
    private static Occurrence findSingleReadOccurrence(@NotNull PsiExpressionStatement statement, @Nullable PsiVariable variable) {
        if (variable == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiCodeBlock.class, PsiLambdaExpression.class});
        if (parent instanceof PsiCodeBlock) {
            PsiStatement prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
            PsiStatement nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PsiStatement.class);
            if (prevStatement instanceof PsiExpressionStatement || nextStatement instanceof PsiExpressionStatement) {
                PsiReferenceExpression nextOccurrence;
                PsiReferenceExpression prevOccurrence;
                ControlFlow flow = InlineIncrementIntention.getControlFlow(parent);
                if (prevStatement instanceof PsiExpressionStatement && (prevOccurrence = ControlFlowUtil.findSingleReadOccurrence(flow, (PsiElement)prevStatement, variable)) != null) {
                    return new Occurrence(prevOccurrence, true);
                }
                if (nextStatement instanceof PsiExpressionStatement && (nextOccurrence = ControlFlowUtil.findSingleReadOccurrence(flow, (PsiElement)nextStatement, variable)) != null) {
                    return new Occurrence(nextOccurrence, false);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiVariable resolveSimpleVariableReference(@NotNull PsiReferenceExpression expression2) {
        PsiExpression qualifierExpression2 = expression2.getQualifierExpression();
        if (qualifierExpression2 == null || qualifierExpression2 instanceof PsiThisExpression || qualifierExpression2 instanceof PsiSuperExpression) {
            PsiElement resolved = expression2.resolve();
            return resolved instanceof PsiVariable ? (PsiVariable)resolved : null;
        }
        return null;
    }

    @NotNull
    public static ControlFlow getControlFlow(@NotNull PsiElement body2) {
        try {
            LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
            return ControlFlowFactory.getInstance(body2.getProject()).getControlFlow(body2, policy, false, false);
        }
        catch (AnalysisCanceledException e) {
            return ControlFlow.EMPTY;
        }
    }

    private static class Occurrence {
        @NotNull
        final PsiReferenceExpression referenceExpression;
        final boolean isPrevious;

        private Occurrence(@NotNull PsiReferenceExpression referenceExpression, boolean isPrevious) {
            this.referenceExpression = referenceExpression;
            this.isPrevious = isPrevious;
        }
    }
}

