/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.initialization;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.initialization.SplitDeclarationAndInitializationPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class SplitDeclarationAndInitializationIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new SplitDeclarationAndInitializationPredicate();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class}) != null && super.isAvailable(project, editor, element);
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiModifierList modifierList;
        PsiField field = (PsiField)element.getParent();
        PsiExpression initializer = field.getInitializer();
        if (initializer == null) {
            return;
        }
        String initializerText = RefactoringUtil.convertInitializerToNormalExpression(initializer, field.getType()).getText();
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return;
        }
        boolean fieldIsStatic = field.hasModifierProperty("static");
        PsiClassInitializer[] classInitializers = containingClass.getInitializers();
        PsiClassInitializer classInitializer = null;
        int fieldOffset = field.getTextOffset();
        for (PsiClassInitializer existingClassInitializer : classInitializers) {
            boolean initializerIsStatic;
            int initializerOffset = existingClassInitializer.getTextOffset();
            if (initializerOffset <= fieldOffset || (initializerIsStatic = existingClassInitializer.hasModifierProperty("static")) != fieldIsStatic) continue;
            Predicate<PsiReference> usedBeforeInitializer = ref -> {
                PsiElement refElement = ref.getElement();
                TextRange textRange = refElement.getTextRange();
                return textRange == null || textRange.getStartOffset() < initializerOffset;
            };
            if (!ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)containingClass)).findAll().stream().noneMatch(usedBeforeInitializer)) continue;
            classInitializer = existingClassInitializer;
            break;
        }
        PsiManager manager = field.getManager();
        Project project = manager.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        if (classInitializer == null) {
            if (PsiUtil.isJavaToken((PsiElement)PsiTreeUtil.skipWhitespacesForward((PsiElement)field), (IElementType)JavaTokenType.COMMA)) {
                field.normalizeDeclaration();
            }
            classInitializer = (PsiClassInitializer)containingClass.addAfter((PsiElement)elementFactory.createClassInitializer(), (PsiElement)field);
            PsiElement whitespace = PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n");
            containingClass.addAfter(whitespace, (PsiElement)field);
        }
        PsiCodeBlock body2 = classInitializer.getBody();
        String initializationStatementText = field.getName() + " = " + initializerText + ';';
        PsiExpressionStatement statement = (PsiExpressionStatement)elementFactory.createStatementFromText(initializationStatementText, (PsiElement)body2);
        PsiElement addedElement = body2.addAfter((PsiElement)statement, null);
        if (fieldIsStatic && (modifierList = classInitializer.getModifierList()) != null) {
            modifierList.setModifierProperty("static", true);
        }
        initializer.delete();
        CodeStyleManager.getInstance((Project)manager.getProject()).reformat((PsiElement)classInitializer);
        HighlightUtil.highlightElement(addedElement, IntentionPowerPackBundle.message("press.escape.to.remove.highlighting.message", new Object[0]));
    }
}

