/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.modifiers;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.javadoc.PsiDocComment;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

class ModifierPredicate
implements PsiElementPredicate {
    @PsiModifier.ModifierConstant
    private final String myModifier;

    ModifierPredicate(@NotNull @PsiModifier.ModifierConstant String modifier) {
        this.myModifier = modifier;
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        PsiModifierListOwner owner;
        PsiModifierList modifierList;
        PsiMethod method;
        PsiClass containingClass;
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiClass) && !(parent instanceof PsiField) && !(parent instanceof PsiMethod) || parent instanceof PsiEnumConstant) {
            return false;
        }
        if (element instanceof PsiDocComment || element instanceof PsiCodeBlock) {
            return false;
        }
        PsiNameIdentifierOwner named = (PsiNameIdentifierOwner)parent;
        PsiElement identifier = named.getNameIdentifier();
        if (identifier == null || identifier.getTextRange().getEndOffset() <= element.getTextRange().getStartOffset()) {
            return false;
        }
        if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            if (aClass.getParent() instanceof PsiDeclarationStatement) {
                return false;
            }
            if (aClass.getContainingClass() == null && (this.myModifier.equals("private") || this.myModifier.equals("protected"))) {
                return false;
            }
        } else if (parent instanceof PsiMethod && ((containingClass = (method = (PsiMethod)parent).getContainingClass()) == null || containingClass.isInterface() || method.isConstructor() && containingClass.isEnum())) {
            return false;
        }
        return (modifierList = (owner = (PsiModifierListOwner)parent).getModifierList()) != null && !modifierList.hasModifierProperty(this.myModifier);
    }
}

