/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.switchtoif;

import com.intellij.codeInsight.daemon.impl.quickfix.ConvertSwitchToIfIntention;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;
import org.jetbrains.annotations.NotNull;

class SwitchPredicate
implements PsiElementPredicate {
    SwitchPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        IElementType tokenType = token.getTokenType();
        if (!JavaTokenType.SWITCH_KEYWORD.equals(tokenType)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiSwitchStatement)) {
            return false;
        }
        return SwitchPredicate.checkSwitchStatement((PsiSwitchStatement)parent);
    }

    public static boolean checkSwitchStatement(@NotNull PsiSwitchStatement switchStatement) {
        PsiStatement[] statements;
        PsiExpression expression2 = switchStatement.getExpression();
        if (expression2 == null) {
            return false;
        }
        PsiCodeBlock body2 = switchStatement.getBody();
        if (body2 == null) {
            return false;
        }
        if (ErrorUtil.containsError((PsiElement)switchStatement)) {
            return false;
        }
        if (!ConvertSwitchToIfIntention.isAvailable(switchStatement)) {
            return false;
        }
        for (PsiStatement statement : statements = body2.getStatements()) {
            if (!(statement instanceof PsiSwitchLabelStatementBase) || ((PsiSwitchLabelStatementBase)statement).isDefaultCase()) continue;
            return true;
        }
        return false;
    }
}

