/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.ExpandBooleanPredicate;
import org.jetbrains.annotations.NotNull;

public class ExpandBooleanIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ExpandBooleanPredicate();
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        if (element instanceof PsiDeclarationStatement) {
            return IntentionPowerPackBundle.message("expand.boolean.declaration.intention.name", new Object[0]);
        }
        if (element instanceof PsiReturnStatement) {
            return IntentionPowerPackBundle.message("expand.boolean.return.intention.name", new Object[0]);
        }
        return IntentionPowerPackBundle.message("expand.boolean.assignment.intention.name", new Object[0]);
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        if (!(element instanceof PsiStatement)) {
            return;
        }
        PsiStatement statement = (PsiStatement)element;
        if (ExpandBooleanPredicate.isBooleanAssignment(statement)) {
            PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)statement;
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)assignmentStatement.getExpression();
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (rhs == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            tracker.markUnchanged(rhs);
            String lhsText = assignmentExpression.getLExpression().getText();
            String signText = assignmentExpression.getOperationSign().getText();
            String newStatementText = "if(" + (signText.length() == 2 ? lhsText + signText.charAt(0) : "") + "true)" + lhsText + "=true; else " + lhsText + "=false;";
            PsiIfStatement newIfStatement = (PsiIfStatement)JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText(newStatementText, element);
            PsiExpression condition2 = newIfStatement.getCondition();
            if (condition2 instanceof PsiBinaryExpression) {
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
                PsiExpression operand2 = binaryExpression.getROperand();
                if (operand2 != null) {
                    operand2.replace((PsiElement)rhs);
                }
            } else {
                condition2.replace((PsiElement)rhs);
            }
            tracker.replaceAndRestoreComments((PsiElement)statement, (PsiElement)newIfStatement);
        } else if (ExpandBooleanPredicate.isBooleanReturn(statement)) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return;
            }
            String newStatementText = "if(true) return true; else return false;";
            PsiIfStatement newIfStatement = (PsiIfStatement)JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText("if(true) return true; else return false;", element);
            PsiExpression condition3 = newIfStatement.getCondition();
            assert (condition3 != null);
            CommentTracker tracker = new CommentTracker();
            tracker.markUnchanged(returnValue);
            condition3.replace((PsiElement)returnValue);
            tracker.replaceAndRestoreComments((PsiElement)statement, (PsiElement)newIfStatement);
        } else if (ExpandBooleanPredicate.isBooleanDeclaration(statement)) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
            PsiElement declaredElement = declarationStatement.getDeclaredElements()[0];
            if (!(declaredElement instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable variable = (PsiLocalVariable)declaredElement;
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            String name = variable.getName();
            String newStatementText = "if(true) " + name + "=true; else " + name + "=false;";
            Project project = statement.getProject();
            PsiIfStatement newIfStatement = (PsiIfStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText(newStatementText, (PsiElement)statement);
            PsiExpression condition4 = newIfStatement.getCondition();
            assert (condition4 != null);
            condition4.replace((PsiElement)initializer);
            CodeStyleManager.getInstance((Project)project).reformat(declarationStatement.getParent().addAfter((PsiElement)newIfStatement, (PsiElement)declarationStatement));
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement.isInferredType() && PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement) == null) {
                return;
            }
            initializer.delete();
        }
    }
}

