/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.MergeElseIfPredicate;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MergeElseIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new MergeElseIfPredicate();
    }

    @Override
    public void processIntention(PsiElement element) {
        PsiJavaToken token = (PsiJavaToken)element;
        PsiIfStatement parentStatement = (PsiIfStatement)token.getParent();
        assert (parentStatement != null);
        PsiBlockStatement elseBranch = (PsiBlockStatement)parentStatement.getElseBranch();
        assert (elseBranch != null);
        PsiElement lastChild = elseBranch.getLastChild();
        PsiCodeBlock elseBranchBlock = elseBranch.getCodeBlock();
        PsiStatement elseBranchContents = elseBranchBlock.getStatements()[0];
        PsiElement grandParent = parentStatement.getParent();
        if (lastChild instanceof PsiComment) {
            MergeElseIfIntention.addElementAndPrevWhiteSpace(lastChild, grandParent, (PsiElement)parentStatement);
        }
        ArrayList before = new ArrayList(1);
        ArrayList after = new ArrayList(1);
        MergeElseIfIntention.collectComments(elseBranchContents, before, after);
        for (PsiComment comment : before) {
            MergeElseIfIntention.addElementAndPrevWhiteSpace((PsiElement)comment, (PsiElement)parentStatement, (PsiElement)token);
        }
        for (PsiComment comment : after) {
            grandParent.addAfter((PsiElement)comment, (PsiElement)parentStatement);
        }
        PsiReplacementUtil.replaceStatement((PsiStatement)elseBranch, elseBranchContents.getText());
    }

    private static void addElementAndPrevWhiteSpace(PsiElement element, PsiElement container, PsiElement anchor) {
        PsiElement sibling = element.getPrevSibling();
        container.addAfter(element, anchor);
        if (sibling instanceof PsiWhiteSpace) {
            container.addAfter(sibling, anchor);
        }
    }

    private static void collectComments(PsiStatement statement, List<? super PsiComment> before, List<? super PsiComment> after) {
        for (PsiElement prevSibling = statement.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
            if (!(prevSibling instanceof PsiComment)) continue;
            before.add((PsiComment)((PsiComment)prevSibling));
        }
        for (PsiElement nextSibing = statement.getNextSibling(); nextSibing != null; nextSibing = nextSibing.getNextSibling()) {
            if (!(nextSibing instanceof PsiComment)) continue;
            after.add((PsiComment)((PsiComment)nextSibing));
        }
    }
}

