/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.SplitElseIfPredicate;
import org.jetbrains.annotations.NotNull;

public class SplitElseIfIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new SplitElseIfPredicate();
    }

    @Override
    public void processIntention(PsiElement element) {
        PsiJavaToken token = (PsiJavaToken)element;
        PsiIfStatement parentStatement = (PsiIfStatement)token.getParent();
        if (parentStatement == null) {
            return;
        }
        PsiStatement elseBranch = parentStatement.getElseBranch();
        if (elseBranch == null) {
            return;
        }
        Project project = element.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiBlockStatement blockStatement = (PsiBlockStatement)elementFactory.createStatementFromText("{}", (PsiElement)elseBranch);
        blockStatement.getCodeBlock().add((PsiElement)elseBranch);
        CodeStyleManager.getInstance((Project)project).reformat(elseBranch.replace((PsiElement)blockStatement));
    }
}

