/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.types;

import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodBodyFix;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class MakeMethodDefaultIntention
extends BaseElementAtCaretIntentionAction {
    private String text = "Make method default";

    @NotNull
    public String getText() {
        return this.text;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiClass containingClass;
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (psiMethod != null && PsiUtil.isLanguageLevel8OrHigher((PsiElement)psiMethod) && psiMethod.getBody() == null && !psiMethod.hasModifierProperty("default") && (containingClass = psiMethod.getContainingClass()) != null && containingClass.isInterface() && !containingClass.isAnnotationType()) {
            this.text = "Make '" + psiMethod.getName() + "()' default";
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (psiMethod != null) {
            PsiModifierList modifierList = psiMethod.getModifierList();
            modifierList.setModifierProperty("default", true);
            new AddMethodBodyFix(psiMethod).invoke(project, editor, psiMethod.getContainingFile());
        }
    }
}

