/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.varargs.VarargArgumentsPredicate;
import org.jetbrains.annotations.NotNull;

public class WrapVarargArgumentsWithExplicitArrayIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new VarargArgumentsPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiCall call = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCall.class);
        if (call == null) {
            return;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PsiExpression[] arguments = argumentList.getExpressions();
        StringBuilder newExpressionText = new StringBuilder("new ");
        PsiParameter[] parameters2 = parameterList.getParameters();
        int varargParameterIndex = parametersCount - 1;
        PsiType componentType = PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)varargParameterIndex, (boolean)true);
        JavaResolveResult resolveResult = call.resolveMethodGenerics();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiType type2 = substitutor.substitute(componentType);
        if (type2 instanceof PsiCapturedWildcardType) {
            type2 = ((PsiCapturedWildcardType)type2).getLowerBound();
        }
        newExpressionText.append(JavaGenericsUtil.isReifiableType((PsiType)type2) ? type2.getCanonicalText() : TypeConversionUtil.erasure((PsiType)type2).getCanonicalText());
        newExpressionText.append("[]{");
        if (arguments.length > varargParameterIndex) {
            PsiExpression argument1 = arguments[varargParameterIndex];
            argument1.delete();
            newExpressionText.append(argument1.getText());
            for (int i = parametersCount; i < arguments.length; ++i) {
                PsiExpression argument = arguments[i];
                newExpressionText.append(',').append(argument.getText());
                argument.delete();
            }
        }
        newExpressionText.append("}");
        Project project = element.getProject();
        PsiExpression newExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newExpressionText.toString(), element);
        CodeStyleManager.getInstance((Project)project).reformat(argumentList.add((PsiElement)newExpression));
    }
}

