/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.config.FilterPattern;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class GenerateToStringUtils {
    private static final Logger log = Logger.getInstance((String)"#GenerateToStringUtils");

    private GenerateToStringUtils() {
    }

    @NotNull
    public static PsiField[] filterAvailableFields(PsiClass clazz, FilterPattern pattern) {
        return GenerateToStringUtils.filterAvailableFields(clazz, false, pattern);
    }

    @NotNull
    public static PsiField[] filterAvailableFields(PsiClass clazz, boolean includeSuperClass, FilterPattern pattern) {
        if (log.isDebugEnabled()) {
            log.debug("Filtering fields using the pattern: " + pattern);
        }
        ArrayList availableFields = new ArrayList();
        GenerateToStringUtils.collectAvailableFields(clazz, (PsiElement)clazz, includeSuperClass, pattern, availableFields, new HashSet());
        return availableFields.toArray(PsiField.EMPTY_ARRAY);
    }

    private static void collectAvailableFields(PsiClass clazz, PsiElement place, boolean includeSuperClass, FilterPattern pattern, List<? super PsiField> availableFields, HashSet<? super PsiClass> visited) {
        PsiField[] fields;
        PsiClass superClass;
        int sortElements = GenerateToStringContext.getConfig().getSortElements();
        if (includeSuperClass && sortElements == 3 && (superClass = clazz.getSuperClass()) != null && visited.add((PsiClass)superClass)) {
            GenerateToStringUtils.collectAvailableFields(superClass, place, true, pattern, availableFields, visited);
        }
        for (PsiField field : fields = includeSuperClass && sortElements != 3 ? clazz.getAllFields() : clazz.getFields()) {
            if (!JavaResolveUtil.isAccessible((PsiMember)field, field.getContainingClass(), field.getModifierList(), place, null, null) || pattern.fieldMatches(field)) continue;
            availableFields.add((PsiField)field);
        }
    }

    @NotNull
    public static PsiMethod[] filterAvailableMethods(PsiClass clazz, @NotNull FilterPattern pattern) {
        if (log.isDebugEnabled()) {
            log.debug("Filtering methods using the pattern: " + pattern);
        }
        ArrayList availableMethods = new ArrayList();
        GenerateToStringUtils.collectAvailableMethods(clazz, clazz, pattern, availableMethods, new HashSet());
        return availableMethods.toArray(PsiMethod.EMPTY_ARRAY);
    }

    private static void collectAvailableMethods(PsiClass clazz, PsiClass base, @NotNull FilterPattern pattern, List<? super PsiMethod> availableMethods, HashSet<? super PsiClass> visited) {
        PsiMethod[] methods;
        PsiClass superClass;
        int sortElements = GenerateToStringContext.getConfig().getSortElements();
        if (sortElements == 3 && (superClass = clazz.getSuperClass()) != null && visited.add((PsiClass)superClass)) {
            GenerateToStringUtils.collectAvailableMethods(superClass, base, pattern, availableMethods, visited);
        }
        for (PsiMethod method : methods = sortElements != 3 ? clazz.getAllMethods() : clazz.getMethods()) {
            String methodName;
            String fieldName;
            PsiType returnType;
            if (!PsiAdapter.isGetterMethod(method) || (returnType = method.getReturnType()) == null || PsiType.VOID.equals((Object)returnType) || !method.hasModifierProperty("public") || method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || base.findFieldByName(fieldName = PsiAdapter.getGetterFieldName(method), false) != null || "toString".equals(methodName = method.getName()) || "getClass".equals(methodName) || "hashCode".equals(methodName) || pattern.methodMatches(method)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Adding the method " + methodName + " as there is not a field for this getter");
            }
            availableMethods.add((PsiMethod)method);
        }
    }
}

