/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.inspection;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtilBase;
import gnu.trove.THashSet;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringContext;
import org.jetbrains.java.generate.GenerateToStringUtils;
import org.jetbrains.java.generate.inspection.AbstractToStringInspection;

public class FieldNotUsedInToStringInspection
extends AbstractToStringInspection {
    @NotNull
    public String getDisplayName() {
        return "Field not used in 'toString()' method";
    }

    @NotNull
    public String getShortName() {
        return "FieldNotUsedInToString";
    }

    public boolean runForWholeFile() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new FieldNotUsedInToStringVisitor(holder);
    }

    private static class FieldUsedVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final THashSet<PsiField> myUnusedFields = new THashSet();
        private final THashSet<PsiMethod> myUnusedMethods = new THashSet();

        FieldUsedVisitor(PsiField[] fields, PsiMethod[] methods) {
            Collections.addAll(this.myUnusedFields, fields);
            Collections.addAll(this.myUnusedMethods, methods);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            if (this.myUnusedFields.isEmpty() && this.myUnusedMethods.isEmpty()) {
                return;
            }
            super.visitReferenceExpression(expression2);
            PsiElement target = expression2.resolve();
            if (target instanceof PsiField) {
                PsiField field = (PsiField)target;
                this.myUnusedFields.remove((Object)field);
            } else if (target instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)target;
                if (FieldUsedVisitor.usesReflection(method)) {
                    this.myUnusedFields.clear();
                    this.myUnusedMethods.clear();
                } else {
                    this.myUnusedMethods.remove((Object)method);
                    PsiField field = PropertyUtilBase.findPropertyFieldByMember((PsiMember)method);
                    this.myUnusedFields.remove((Object)field);
                }
            }
        }

        private static boolean usesReflection(PsiMethod method) {
            String name = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if ("getDeclaredFields".equals(name)) {
                return "java.lang.Class".equals(qualifiedName);
            }
            if ("toString".equals(name)) {
                return "org.apache.commons.lang.builder.ReflectionToStringBuilder".equals(qualifiedName) || "java.util.Objects".equals(qualifiedName);
            }
            return false;
        }

        THashSet<PsiField> getUnusedFields() {
            return this.myUnusedFields;
        }

        THashSet<PsiMethod> getUnusedMethods() {
            return this.myUnusedMethods;
        }
    }

    private static class FieldNotUsedInToStringVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        private FieldNotUsedInToStringVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            String methodName = method.getName();
            if (!"toString".equals(methodName)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (!parameterList.isEmpty()) {
                return;
            }
            PsiType returnType = method.getReturnType();
            PsiClassType javaLangString = PsiType.getJavaLangString((PsiManager)method.getManager(), (GlobalSearchScope)method.getResolveScope());
            if (!javaLangString.equals((Object)returnType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            PsiField[] fields = GenerateToStringUtils.filterAvailableFields(aClass, GenerateToStringContext.getConfig().getFilterPattern());
            PsiMethod[] methods = GenerateToStringContext.getConfig().isEnableMethods() ? GenerateToStringUtils.filterAvailableMethods(aClass, GenerateToStringContext.getConfig().getFilterPattern()) : PsiMethod.EMPTY_ARRAY;
            FieldUsedVisitor visitor = new FieldUsedVisitor(fields, methods);
            method.accept((PsiElementVisitor)visitor);
            for (PsiField field : visitor.getUnusedFields()) {
                String fieldName = field.getName();
                this.myHolder.registerProblem((PsiElement)field.getNameIdentifier(), "Field '" + fieldName + "' is not used in 'toString()' method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, AbstractToStringInspection.createFixes(this.myHolder));
            }
            for (PsiMethod unusedMethod : visitor.getUnusedMethods()) {
                PsiIdentifier identifier = unusedMethod.getNameIdentifier();
                PsiMethod target = identifier == null ? unusedMethod : identifier;
                this.myHolder.registerProblem((PsiElement)target, "Method '" + unusedMethod.getName() + "' is not used in 'toString()' method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, AbstractToStringInspection.createFixes(this.myHolder));
            }
        }
    }
}

