/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.GenerateToStringActionHandler;

public class GenerateToStringQuickFix
implements LocalQuickFix {
    public static final GenerateToStringQuickFix INSTANCE = new GenerateToStringQuickFix();

    private GenerateToStringQuickFix() {
    }

    public static GenerateToStringQuickFix getInstance() {
        return INSTANCE;
    }

    @NotNull
    public String getName() {
        return "Generate toString()";
    }

    @NotNull
    public String getFamilyName() {
        return "Generate";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor desc) {
        PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)desc.getPsiElement(), PsiClass.class);
        if (clazz == null) {
            return;
        }
        GenerateToStringActionHandler handler = (GenerateToStringActionHandler)ServiceManager.getService(GenerateToStringActionHandler.class);
        handler.executeActionQuickFix(project, clazz);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

