/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.scopes.FirPosition;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/resolve/FirSymbolProvider;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "processClassifiersByName", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "position", "Lorg/jetbrains/kotlin/fir/scopes/FirPosition;", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassifierSymbol;", "resolve"})
public final class FirNestedClassifierScope
implements FirScope {
    @NotNull
    private final ClassId classId;
    private final FirSymbolProvider symbolProvider;

    @Override
    public boolean processClassifiersByName(@NotNull Name name, @NotNull FirPosition position, @NotNull Function1<? super ConeClassifierSymbol, Boolean> processor2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull((Object)position, "position");
        Intrinsics.checkParameterIsNotNull(processor2, "processor");
        ClassId classId = this.classId.createNestedClassId(name);
        Intrinsics.checkExpressionValueIsNotNull(classId, "classId.createNestedClassId(name)");
        ClassId child = classId;
        ConeClassLikeSymbol symbol2 = this.symbolProvider.getClassLikeSymbolByFqName(child);
        return symbol2 == null || processor2.invoke(symbol2) != false;
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    public FirNestedClassifierScope(@NotNull ClassId classId, @NotNull FirSymbolProvider symbolProvider2) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        Intrinsics.checkParameterIsNotNull(symbolProvider2, "symbolProvider");
        this.classId = classId;
        this.symbolProvider = symbolProvider2;
    }

    @Override
    @NotNull
    public ProcessorAction processFunctionsByName(@NotNull Name name, @NotNull Function1<? super ConeFunctionSymbol, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(processor2, "processor");
        return FirScope.DefaultImpls.processFunctionsByName(this, name, processor2);
    }

    @Override
    @NotNull
    public ProcessorAction processPropertiesByName(@NotNull Name name, @NotNull Function1<? super ConeVariableSymbol, ? extends ProcessorAction> processor2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(processor2, "processor");
        return FirScope.DefaultImpls.processPropertiesByName(this, name, processor2);
    }
}

