/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.lang.ASTNode;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueKindUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfoKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J*\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactoryImpl;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containingDeclarationOrModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolutionContext", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "createDataFlowValueForProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "usageContainingModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createDataFlowValueForStableReceiver", "receiver", "isComplexExpression", "", "frontend"})
public final class DataFlowValueFactoryImpl
implements DataFlowValueFactory {
    private final LanguageVersionSettings languageVersionSettings;

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkParameterIsNotNull(receiverValue, "receiverValue");
        Intrinsics.checkParameterIsNotNull(resolutionContext, "resolutionContext");
        BindingTrace bindingTrace = resolutionContext.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "resolutionContext.trace");
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "resolutionContext.trace.bindingContext");
        return this.createDataFlowValue(receiverValue, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        DataFlowValue dataFlowValue2;
        Intrinsics.checkParameterIsNotNull(receiverValue, "receiverValue");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(containingDeclarationOrModule, "containingDeclarationOrModule");
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 instanceof TransientReceiver || receiverValue2 instanceof ImplicitReceiver) {
            dataFlowValue2 = this.createDataFlowValueForStableReceiver(receiverValue);
        } else if (receiverValue2 instanceof ExpressionReceiver) {
            KtExpression ktExpression = ((ExpressionReceiver)receiverValue).getExpression();
            KotlinType kotlinType2 = receiverValue.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "receiverValue.getType()");
            dataFlowValue2 = this.createDataFlowValue(ktExpression, kotlinType2, bindingContext, containingDeclarationOrModule);
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
        }
        return dataFlowValue2;
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValueForStableReceiver(@NotNull ReceiverValue receiver2) {
        Intrinsics.checkParameterIsNotNull(receiver2, "receiver");
        IdentifierInfo identifierInfo = new IdentifierInfo.Receiver(receiver2);
        KotlinType kotlinType2 = receiver2.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "receiver.type");
        return new DataFlowValue(identifierInfo, kotlinType2, null, 4, null);
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValueForProperty(@NotNull KtProperty property2, @NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext, @Nullable ModuleDescriptor usageContainingModule) {
        Intrinsics.checkParameterIsNotNull(property2, "property");
        Intrinsics.checkParameterIsNotNull(variableDescriptor, "variableDescriptor");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        IdentifierInfo.Variable identifierInfo = new IdentifierInfo.Variable(variableDescriptor, DataFlowValueKindUtilsKt.variableKind(variableDescriptor, usageContainingModule, bindingContext, property2, this.languageVersionSettings), (DataFlowValue)bindingContext.get(BindingContext.BOUND_INITIALIZER_VALUE, variableDescriptor));
        IdentifierInfo identifierInfo2 = identifierInfo;
        KotlinType kotlinType2 = variableDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "variableDescriptor.type");
        return new DataFlowValue(identifierInfo2, kotlinType2, null, 4, null);
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(resolutionContext, "resolutionContext");
        BindingTrace bindingTrace = resolutionContext.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "resolutionContext.trace");
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "resolutionContext.trace.bindingContext");
        return this.createDataFlowValue(expression2, type2, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        DataFlowValue dataFlowValue2;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        Intrinsics.checkParameterIsNotNull(type2, "type");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(containingDeclarationOrModule, "containingDeclarationOrModule");
        if (expression2 instanceof KtConstantExpression) {
            ASTNode aSTNode = ((KtConstantExpression)expression2).getNode();
            Intrinsics.checkExpressionValueIsNotNull(aSTNode, "expression.node");
            if (aSTNode.getElementType() == KtNodeTypes.NULL) {
                dataFlowValue2 = DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
                return dataFlowValue2;
            }
        }
        if (KotlinTypeKt.isError(type2)) {
            dataFlowValue2 = DataFlowValue.ERROR;
            return dataFlowValue2;
        }
        if (KotlinBuiltIns.isNullableNothing(type2)) {
            dataFlowValue2 = DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
            return dataFlowValue2;
        }
        if (ExpressionTypingUtils.isExclExclExpression(KtPsiUtil.deparenthesize(expression2))) {
            dataFlowValue2 = new DataFlowValue(new IdentifierInfo.Expression(expression2, false, 2, null), type2, Nullability.NOT_NULL);
            return dataFlowValue2;
        }
        if (this.isComplexExpression(expression2)) {
            dataFlowValue2 = new DataFlowValue(new IdentifierInfo.Expression(expression2, true), type2, null, 4, null);
            return dataFlowValue2;
        }
        IdentifierInfo result2 = IdentifierInfoKt.getIdForStableIdentifier(expression2, bindingContext, containingDeclarationOrModule, this.languageVersionSettings);
        dataFlowValue2 = new DataFlowValue(result2 == IdentifierInfo.NO.INSTANCE ? (IdentifierInfo)new IdentifierInfo.Expression(expression2, false, 2, null) : result2, type2, null, 4, null);
        return dataFlowValue2;
    }

    private final boolean isComplexExpression(KtExpression expression2) {
        KtExpression deparenthesized;
        KtExpression ktExpression = expression2;
        boolean bl = ktExpression instanceof KtBlockExpression || ktExpression instanceof KtIfExpression || ktExpression instanceof KtWhenExpression ? true : (ktExpression instanceof KtBinaryExpression ? ((KtBinaryExpression)expression2).getOperationToken() == KtTokens.ELVIS : (ktExpression instanceof KtParenthesizedExpression ? (deparenthesized = KtPsiUtil.deparenthesize(expression2)) != null && this.isComplexExpression(deparenthesized) : false));
        return bl;
    }

    @Deprecated(message="Please, avoid to use that implementation explicitly. If you need DataFlowValueFactory, use injection")
    public DataFlowValueFactoryImpl(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }
}

