/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.TypeIntersector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u00042\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"intersectTypes", "Lorg/jetbrains/kotlin/types/SimpleType;", "types", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "intersectWrappedTypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "descriptors"})
public final class IntersectionTypeKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final UnwrappedType intersectWrappedTypes(@NotNull Collection<? extends KotlinType> types) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(types, "types");
        Iterable $this$map$iv = types;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType2 = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UnwrappedType unwrappedType = it.unwrap();
            collection.add(unwrappedType);
        }
        return IntersectionTypeKt.intersectTypes((List)destination$iv$iv);
    }

    @NotNull
    public static final SimpleType intersectTypes(@NotNull List<? extends SimpleType> types) {
        Intrinsics.checkParameterIsNotNull(types, "types");
        UnwrappedType unwrappedType = IntersectionTypeKt.intersectTypes(types);
        if (unwrappedType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        }
        return (SimpleType)unwrappedType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final UnwrappedType intersectTypes(@NotNull List<? extends UnwrappedType> types) {
        void $this$mapTo$iv$iv;
        SimpleType simpleType2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull(types, "types");
        switch (types.size()) {
            case 0: {
                String string = "Expected some types";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 1: {
                return CollectionsKt.single(types);
            }
        }
        boolean hasFlexibleTypes = false;
        boolean hasErrorType = false;
        Iterable $this$map$iv = types;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            SimpleType simpleType3;
            void it;
            UnwrappedType unwrappedType = (UnwrappedType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            hasErrorType = hasErrorType || KotlinTypeKt.isError((KotlinType)it);
            void var13_19 = it;
            if (var13_19 instanceof SimpleType) {
                simpleType3 = (SimpleType)it;
            } else if (var13_19 instanceof FlexibleType) {
                if (DynamicTypesKt.isDynamic((KotlinType)it)) {
                    return it;
                }
                hasFlexibleTypes = true;
                simpleType3 = ((FlexibleType)it).getLowerBound();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            simpleType2 = simpleType3;
            collection.add(simpleType2);
        }
        List lowerBounds = (List)destination$iv$iv;
        if (hasErrorType) {
            SimpleType simpleType4 = ErrorUtils.createErrorType("Intersection of error types: " + types);
            Intrinsics.checkExpressionValueIsNotNull(simpleType4, "ErrorUtils.createErrorTy\u2026 of error types: $types\")");
            return simpleType4;
        }
        if (!hasFlexibleTypes) {
            return TypeIntersector.INSTANCE.intersectTypes$descriptors(lowerBounds);
        }
        Iterable $this$map$iv2 = types;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UnwrappedType bl = (UnwrappedType)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            simpleType2 = FlexibleTypesKt.upperIfFlexible((KotlinType)it);
            collection.add(simpleType2);
        }
        List upperBounds = (List)destination$iv$iv2;
        return KotlinTypeFactory.flexibleType(TypeIntersector.INSTANCE.intersectTypes$descriptors(lowerBounds), TypeIntersector.INSTANCE.intersectTypes$descriptors(upperBounds));
    }
}

