/*
 * Decompiled with CFR 0.152.
 */
package com.android.support;

import com.android.support.InvalidDataException;
import com.android.support.MigrationParserVisitor;
import com.android.utils.XmlUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"ATTR_ARTIFACT_NAME", "", "ATTR_GROUP_NAME", "ATTR_NEW_ARTIFACT_NAME", "ATTR_NEW_BASE_VERSION_NAME", "ATTR_NEW_GROUP_NAME", "ATTR_NEW_NAME", "ATTR_OLD_ARTIFACT_NAME", "ATTR_OLD_GROUP_NAME", "ATTR_OLD_NAME", "ATTR_TYPE", "MIGRATE_DEPENDENCY_NAME", "MIGRATE_ENTRY_NAME", "ROOT_ELEMENT", "TYPE_CLASS", "TYPE_PACKAGE", "UPGRADE_DEPENDENCY_NAME", "parseMigrationFile", "", "visitor", "Lcom/android/support/MigrationParserVisitor;", "android.sdktools.common"})
public final class AndroidxMigrationParserKt {
    private static final String ROOT_ELEMENT = "migration-map";
    private static final String MIGRATE_ENTRY_NAME = "migrate";
    private static final String ATTR_OLD_NAME = "old-name";
    private static final String ATTR_NEW_NAME = "new-name";
    private static final String ATTR_TYPE = "type";
    private static final String TYPE_CLASS = "CLASS";
    private static final String TYPE_PACKAGE = "PACKAGE";
    private static final String MIGRATE_DEPENDENCY_NAME = "migrate-dependency";
    private static final String ATTR_OLD_GROUP_NAME = "old-group-name";
    private static final String ATTR_OLD_ARTIFACT_NAME = "old-artifact-name";
    private static final String ATTR_NEW_GROUP_NAME = "new-group-name";
    private static final String ATTR_NEW_ARTIFACT_NAME = "new-artifact-name";
    private static final String ATTR_NEW_BASE_VERSION_NAME = "base-version";
    private static final String UPGRADE_DEPENDENCY_NAME = "upgrade-dependency";
    private static final String ATTR_GROUP_NAME = "group-name";
    private static final String ATTR_ARTIFACT_NAME = "artifact-name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void parseMigrationFile(@NotNull MigrationParserVisitor visitor) {
        InputStream stream = visitor.getClass().getClassLoader().getResourceAsStream("migrateToAndroidx/migration.xml");
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Document document = XmlUtils.parseDocument(new InputStreamReader(stream), false);
            Element root = document.getDocumentElement();
            if (Intrinsics.areEqual((Object)ROOT_ELEMENT, (Object)root.getNodeName()) ^ true) {
                throw (Throwable)new InvalidDataException("Migration file does not start with <migration-map>");
            }
            Iterable<Element> $receiver$iv = XmlUtils.getSubTags(root);
            Iterator<Element> iterator2 = $receiver$iv.iterator();
            block13: while (iterator2.hasNext()) {
                Element element$iv;
                Element node = element$iv = iterator2.next();
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)node.getNodeName(), (Object)MIGRATE_ENTRY_NAME)) {
                    String string;
                    String oldName = node.getAttribute(ATTR_OLD_NAME);
                    String newName = node.getAttribute(ATTR_NEW_NAME);
                    String type = node.getAttribute(ATTR_TYPE);
                    if (type == null) throw (Throwable)new InvalidDataException("Invalid type " + type);
                    int n = -1;
                    switch (string.hashCode()) {
                        case -89079770: {
                            if (!string.equals(TYPE_PACKAGE)) break;
                            n = 1;
                            break;
                        }
                        case 64205144: {
                            if (!string.equals(TYPE_CLASS)) break;
                            n = 2;
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            visitor.visitPackage(oldName, newName);
                            continue block13;
                        }
                        case 2: {
                            visitor.visitClass(oldName, newName);
                            continue block13;
                        }
                        default: {
                            throw (Throwable)new InvalidDataException("Invalid type " + type);
                        }
                    }
                }
                if (Intrinsics.areEqual((Object)node.getNodeName(), (Object)MIGRATE_DEPENDENCY_NAME)) {
                    String oldGroupName = node.getAttribute(ATTR_OLD_GROUP_NAME);
                    String oldArtifactName = node.getAttribute(ATTR_OLD_ARTIFACT_NAME);
                    String newGroupName = node.getAttribute(ATTR_NEW_GROUP_NAME);
                    String newArtifactName = node.getAttribute(ATTR_NEW_ARTIFACT_NAME);
                    String newBaseVersion = node.getAttribute(ATTR_NEW_BASE_VERSION_NAME);
                    visitor.visitGradleCoordinate(oldGroupName, oldArtifactName, newGroupName, newArtifactName, newBaseVersion);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)node.getNodeName(), (Object)UPGRADE_DEPENDENCY_NAME)) continue;
                String groupName = node.getAttribute(ATTR_GROUP_NAME);
                String artifactName = node.getAttribute(ATTR_ARTIFACT_NAME);
                String baseVersion = node.getAttribute(ATTR_NEW_BASE_VERSION_NAME);
                visitor.visitGradleCoordinateUpgrade(groupName, artifactName, baseVersion);
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

