/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.codegen;

import com.android.SdkConstants;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gct.testrecorder.codegen.MatcherBuilder;
import com.google.gct.testrecorder.event.ElementAction;
import com.google.gct.testrecorder.event.ElementDescriptor;
import com.google.gct.testrecorder.event.TestRecorderAssertion;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.google.gct.testrecorder.util.StringHelper;
import com.intellij.lang.java.lexer.JavaLexer;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCodeMapper {
    private static final String VIEW_VARIABLE_CLASS_NAME = "ViewInteraction";
    private static final String DATA_VARIABLE_CLASS_NAME = "DataInteraction";
    private final String myApplicationId;
    private final Project myProject;
    @Nullable
    private final AndroidTargetData myAndroidTargetData;
    private final boolean myIsKotlinTestClass;
    private boolean myIsChildAtPositionAdded;
    private boolean myIsRecyclerViewActionAdded;
    private Set<String> myRequestedPermissions = Sets.newHashSet();
    private final Map<String, Integer> myVariableNameIndexes = Maps.newHashMap();

    public TestCodeMapper(String applicationId, Project project, @Nullable AndroidTargetData androidTargetData, boolean isKotlinTestClass) {
        this.myApplicationId = applicationId;
        this.myProject = project;
        this.myAndroidTargetData = androidTargetData;
        this.myIsKotlinTestClass = isKotlinTestClass;
    }

    public List<String> getTestCodeLinesForEvent(TestRecorderEvent event) {
        ArrayList testCodeLines = Lists.newArrayList();
        if (event.isPermissionsRequest()) {
            this.myRequestedPermissions.addAll(event.getRequestedPermissions());
            return testCodeLines;
        }
        if (event.isPressBack()) {
            testCodeLines.add("pressBack()" + this.getStatementTerminator());
            return testCodeLines;
        }
        if (event.isViewClick() && this.isOverflowMenuButton(event.getElementClassName())) {
            testCodeLines.add("openActionBarOverflowOrOptionsMenu(getInstrumentation().getTargetContext())" + this.getStatementTerminator());
            return testCodeLines;
        }
        if (event.isDelayedMessagePost()) {
            testCodeLines.add(this.createSleepStatement(event.getDelayTime()));
            return testCodeLines;
        }
        String variableName = this.addPickingStatement(event, testCodeLines);
        int recyclerViewChildPosition = event.getElementRecyclerViewChildPosition();
        if (event.isSwipe()) {
            testCodeLines.add(this.createActionStatement(variableName, recyclerViewChildPosition, "swipe" + event.getSwipeDirection().name() + "()", false));
        } else if (event.isPressEditorAction()) {
            testCodeLines.add(this.createActionStatement(variableName, recyclerViewChildPosition, "pressImeActionButton()", false));
        } else if (event.isClickEvent()) {
            testCodeLines.add(this.createActionStatement(variableName, recyclerViewChildPosition, event.isViewLongClick() ? "longClick()" : "click()", event.canScrollTo()));
        } else if (event.isTextChange()) {
            String closeSoftKeyboardAction = TestCodeMapper.doesNeedStandaloneCloseSoftKeyboardAction(event) ? "" : ", closeSoftKeyboard()";
            testCodeLines.add(this.createActionStatement(variableName, recyclerViewChildPosition, "replaceText(" + StringHelper.boxString(event.getReplacementText()) + ")" + closeSoftKeyboardAction, event.canScrollTo()));
        } else {
            throw new RuntimeException("Unsupported event type: " + event.getEventType());
        }
        if (TestCodeMapper.doesNeedStandaloneCloseSoftKeyboardAction(event)) {
            this.addStandaloneCloseSoftKeyboardAction(event, testCodeLines);
        }
        return testCodeLines;
    }

    private void addStandaloneCloseSoftKeyboardAction(TestRecorderEvent textChangeEvent, List<String> testCodeLines) {
        TestRecorderEvent closeSoftKeyboardEvent = new TestRecorderEvent(textChangeEvent.getEventType(), textChangeEvent.getTimestamp());
        List<ElementDescriptor> originalElementDescriptors = textChangeEvent.getElementDescriptorList();
        assert (!originalElementDescriptors.isEmpty());
        ElementDescriptor originalDescriptor = originalElementDescriptors.get(0);
        ElementDescriptor updatedDescriptor = new ElementDescriptor(originalDescriptor.getClassName(), originalDescriptor.getRecyclerViewChildPosition(), originalDescriptor.getAdapterViewChildPosition(), originalDescriptor.getGroupViewChildPosition(), originalDescriptor.getResourceId(), originalDescriptor.getContentDescription(), textChangeEvent.getReplacementText());
        closeSoftKeyboardEvent.addElementDescriptor(updatedDescriptor);
        for (int i = 1; i < originalElementDescriptors.size(); ++i) {
            closeSoftKeyboardEvent.addElementDescriptor(originalElementDescriptors.get(i));
        }
        testCodeLines.add("");
        String variableName = this.addPickingStatement(closeSoftKeyboardEvent, testCodeLines);
        testCodeLines.add(this.createActionStatement(variableName, closeSoftKeyboardEvent.getElementRecyclerViewChildPosition(), "closeSoftKeyboard()", false));
    }

    private static boolean doesNeedStandaloneCloseSoftKeyboardAction(TestRecorderEvent event) {
        return TestRecorderSettings.getInstance().USE_TEXT_FOR_ELEMENT_MATCHING && event.isTextChange() && (!Strings.isNullOrEmpty((String)event.getElementText()) || event.getElementRecyclerViewChildPosition() != -1);
    }

    private String createSleepStatement(long sleepTime) {
        return String.format(" // Added a sleep statement to match the app's execution delay.\n // The recommended way to handle such scenarios is to use Espresso idling resources:\n  // https://google.github.io/android-testing-support-library/docs/espresso/idling-resource/index.html\n" + (this.myIsKotlinTestClass ? "Thread.sleep(%s)" : "try {\n Thread.sleep(%s);\n } catch (InterruptedException e) {\n e.printStackTrace();\n }"), sleepTime);
    }

    boolean isOverflowMenuButton(String className) {
        if (StringUtils.isEmpty((String)className)) {
            return false;
        }
        return className.startsWith("android.") && className.endsWith(".widget.ActionMenuPresenter.OverflowMenuButton");
    }

    private String createActionStatement(String variableName, int recyclerViewChildPosition, String action, boolean addScrollTo) {
        this.myIsRecyclerViewActionAdded = this.myIsRecyclerViewActionAdded || recyclerViewChildPosition != -1;
        String completeAction = (addScrollTo && recyclerViewChildPosition == -1 ? "scrollTo(), " : "") + action;
        completeAction = recyclerViewChildPosition == -1 ? completeAction : this.getActionOnItemAtPositionMethodCallPrefix() + recyclerViewChildPosition + ", " + completeAction + ")";
        return variableName + ".perform(" + completeAction + ")" + this.getStatementTerminator();
    }

    private String getActionOnItemAtPositionMethodCallPrefix() {
        return this.myIsKotlinTestClass ? "actionOnItemAtPosition<ViewHolder>(" : "actionOnItemAtPosition(";
    }

    public List<String> getTestCodeLinesForAssertion(TestRecorderAssertion assertion) {
        LinkedList<String> testCodeLines = new LinkedList<String>();
        String rule = assertion.getRule();
        String variableName = this.addPickingStatement(assertion, testCodeLines);
        if ("does not exist".equals(rule)) {
            testCodeLines.add(variableName + ".check(doesNotExist())" + this.getStatementTerminator());
        } else if ("exists".equals(rule)) {
            testCodeLines.add(variableName + ".check(matches(isDisplayed()))" + this.getStatementTerminator());
        } else if ("text is".equals(rule)) {
            String text = assertion.getText();
            testCodeLines.add(variableName + ".check(matches(withText(" + StringHelper.boxString(text) + ")))" + this.getStatementTerminator());
        } else {
            throw new RuntimeException("Unsupported assertion rule: " + rule);
        }
        return testCodeLines;
    }

    private String addPickingStatement(ElementAction action, List<String> testCodeLines) {
        if (TestCodeMapper.isAdapterViewAction(action)) {
            return this.addDataPickingStatement(action, testCodeLines);
        }
        return this.addViewPickingStatement(action, testCodeLines);
    }

    private String addViewPickingStatement(ElementAction action, List<String> testCodeLines) {
        int startIndex = action.getElementRecyclerViewChildPosition() != -1 && action.getElementDescriptorsCount() > 1 ? 1 : 0;
        String variableName = this.generateVariableNameFromElementClassName(action.getElementDescriptor(startIndex).getClassName(), VIEW_VARIABLE_CLASS_NAME);
        testCodeLines.add(this.getVariableTypeDeclaration(true) + " " + variableName + " = onView(\n" + this.generateElementHierarchyConditions(action, startIndex) + ")" + this.getStatementTerminator());
        return variableName;
    }

    private String addDataPickingStatement(ElementAction action, List<String> testCodeLines) {
        String variableName = this.generateVariableNameFromElementClassName(action.getElementClassName(), DATA_VARIABLE_CLASS_NAME);
        testCodeLines.add(this.getVariableTypeDeclaration(false) + " " + variableName + " = onData(anything())\n.inAdapterView(" + this.generateElementHierarchyConditions(action, 1) + ")\n.atPosition(" + action.getElementAdapterViewChildPosition() + ")" + this.getStatementTerminator());
        return variableName;
    }

    private String getVariableTypeDeclaration(boolean isOnViewInteraction) {
        if (this.myIsKotlinTestClass) {
            return "val";
        }
        return isOnViewInteraction ? VIEW_VARIABLE_CLASS_NAME : DATA_VARIABLE_CLASS_NAME;
    }

    private String getStatementTerminator() {
        return this.myIsKotlinTestClass ? "" : ";";
    }

    private static boolean isAdapterViewAction(ElementAction action) {
        return action.getElementAdapterViewChildPosition() != -1 && action.getElementDescriptorsCount() > 1;
    }

    private String generateVariableNameFromElementClassName(@Nullable String elementClassName, @NotNull String defaultClassName) {
        if (Strings.isNullOrEmpty((String)elementClassName)) {
            return this.generateVariableNameFromTemplate(defaultClassName);
        }
        return this.generateVariableNameFromTemplate(StringHelper.getClassName(elementClassName));
    }

    private String generateVariableNameFromTemplate(String template) {
        Integer unusedIndex;
        String variableName = StringHelper.lowerCaseFirstCharacter(template);
        if (JavaLexer.isKeyword((String)variableName, (LanguageLevel)LanguageLevel.HIGHEST)) {
            variableName = variableName + "_";
        }
        if ((unusedIndex = this.myVariableNameIndexes.get(variableName)) == null) {
            this.myVariableNameIndexes.put(variableName, 2);
            return variableName;
        }
        this.myVariableNameIndexes.put(variableName, unusedIndex + 1);
        return variableName + unusedIndex;
    }

    private String generateElementHierarchyConditions(ElementAction action, int startIndex) {
        List<ElementDescriptor> elementDescriptors = action.getElementDescriptorList();
        if (elementDescriptors.size() <= startIndex) {
            return "UNKNOWN";
        }
        return this.generateElementHierarchyConditionsRecursively(action instanceof TestRecorderAssertion, !action.canScrollTo(), elementDescriptors, startIndex);
    }

    private String generateElementHierarchyConditionsRecursively(boolean isAssertionConditions, boolean checkIsDisplayed, List<ElementDescriptor> elementDescriptors, int index) {
        boolean addIsDisplayed = checkIsDisplayed && index == 0;
        ElementDescriptor elementDescriptor = elementDescriptors.get(index);
        MatcherBuilder matcherBuilder = new MatcherBuilder(this.myProject, this.myIsKotlinTestClass);
        int lastIndex = elementDescriptors.size() - 1;
        if (elementDescriptor.isEmpty() || index == lastIndex && elementDescriptor.isEmptyIgnoringChildPosition() || index == 0 && this.isLoginRadioButton(elementDescriptors)) {
            matcherBuilder.addMatcher(MatcherBuilder.Kind.ClassName, elementDescriptor.getClassName(), true, isAssertionConditions);
        } else {
            String resourceId = elementDescriptor.getResourceId();
            if (this.isAndroidFrameworkPrivateId(resourceId)) {
                matcherBuilder.addMatcher(MatcherBuilder.Kind.ClassName, elementDescriptor.getClassName(), true, isAssertionConditions);
            } else {
                matcherBuilder.addMatcher(MatcherBuilder.Kind.Id, this.convertIdToTestCodeFormat(resourceId), false, isAssertionConditions);
            }
            if (TestRecorderSettings.getInstance().USE_TEXT_FOR_ELEMENT_MATCHING) {
                matcherBuilder.addMatcher(MatcherBuilder.Kind.Text, elementDescriptor.getText(), true, isAssertionConditions);
            }
            if (TestRecorderSettings.getInstance().USE_CONTENT_DESCRIPTION_FOR_ELEMENT_MATCHING) {
                matcherBuilder.addMatcher(MatcherBuilder.Kind.ContentDescription, elementDescriptor.getContentDescription(), true, isAssertionConditions);
            }
        }
        if (index == lastIndex) {
            if (matcherBuilder.getMatcherCount() > 1 || addIsDisplayed) {
                return "allOf(" + matcherBuilder.getMatchers() + (addIsDisplayed ? ", isDisplayed()" : "") + ")";
            }
            return matcherBuilder.getMatchers();
        }
        boolean addAllOf = matcherBuilder.getMatcherCount() > 0 || addIsDisplayed;
        int groupViewChildPosition = elementDescriptor.getGroupViewChildPosition();
        if (SdkConstants.CLASS_VIEW_PAGER.isEquals(elementDescriptors.get(index + 1).getClassName())) {
            groupViewChildPosition = -1;
        }
        this.myIsChildAtPositionAdded = this.myIsChildAtPositionAdded || groupViewChildPosition != -1;
        return (addAllOf ? "allOf(" : "") + matcherBuilder.getMatchers() + (matcherBuilder.getMatcherCount() > 0 ? ",\n" : "") + (groupViewChildPosition != -1 ? "childAtPosition(\n" : "withParent(") + this.generateElementHierarchyConditionsRecursively(isAssertionConditions, checkIsDisplayed, elementDescriptors, index + 1) + (groupViewChildPosition != -1 ? ",\n" + groupViewChildPosition : "") + ")" + (addIsDisplayed ? ",\nisDisplayed()" : "") + (addAllOf ? ")" : "");
    }

    private boolean isAndroidFrameworkPrivateId(String resourceId) {
        Pair<String, String> parsedId = StringHelper.parseId(resourceId);
        return this.myAndroidTargetData != null && parsedId != null && "android".equals(parsedId.getFirst()) && !this.myAndroidTargetData.isResourcePublic(ResourceType.ID.getName(), (String)parsedId.getSecond());
    }

    private boolean isLoginRadioButton(List<ElementDescriptor> elementDescriptors) {
        return elementDescriptors.size() > 1 && elementDescriptors.get(0).getClassName().endsWith(".widget.AppCompatRadioButton") && "R.id.welcome_account_list".equals(this.convertIdToTestCodeFormat(elementDescriptors.get(1).getResourceId()));
    }

    private String convertIdToTestCodeFormat(String resourceId) {
        Pair<String, String> parsedId = StringHelper.parseId(resourceId);
        if (parsedId == null) {
            return resourceId;
        }
        String testCodeId = "R.id." + (String)parsedId.getSecond();
        if (!((String)parsedId.getFirst()).equals(this.myApplicationId)) {
            testCodeId = (String)parsedId.getFirst() + "." + testCodeId;
        }
        return testCodeId;
    }

    public boolean isChildAtPositionAdded() {
        return this.myIsChildAtPositionAdded;
    }

    public boolean isRecyclerViewActionAdded() {
        return this.myIsRecyclerViewActionAdded;
    }

    public Set<String> getRequestedPermissions() {
        return ImmutableSet.copyOf(this.myRequestedPermissions);
    }
}

