/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.FilePatternSet;
import org.jetbrains.plugins.gradle.model.FilePatternSetImpl;

public class DefaultExternalSourceDirectorySet
implements ExternalSourceDirectorySet {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myName;
    @NotNull
    private Set<File> mySrcDirs = new HashSet<File>();
    private File myOutputDir;
    private final List<File> myGradleOutputDirs;
    private final FilePatternSet myPatterns;
    @NotNull
    private List<ExternalFilter> myFilters = new ArrayList<ExternalFilter>();
    private boolean myInheritedCompilerOutput;

    public DefaultExternalSourceDirectorySet() {
        this.myGradleOutputDirs = new ArrayList<File>();
        this.myPatterns = new FilePatternSetImpl(new LinkedHashSet<String>(), new LinkedHashSet<String>());
    }

    public DefaultExternalSourceDirectorySet(ExternalSourceDirectorySet sourceDirectorySet) {
        this();
        this.myName = sourceDirectorySet.getName();
        this.mySrcDirs = new HashSet<File>(sourceDirectorySet.getSrcDirs());
        this.myOutputDir = sourceDirectorySet.getOutputDir();
        this.myGradleOutputDirs.addAll(sourceDirectorySet.getGradleOutputDirs());
        this.myPatterns.getIncludes().addAll(sourceDirectorySet.getPatterns().getIncludes());
        this.myPatterns.getExcludes().addAll(sourceDirectorySet.getPatterns().getExcludes());
        for (ExternalFilter filter : sourceDirectorySet.getFilters()) {
            this.myFilters.add(new DefaultExternalFilter(filter));
        }
        this.myInheritedCompilerOutput = sourceDirectorySet.isCompilerOutputPathInherited();
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String name) {
        this.myName = name;
    }

    @NotNull
    public Set<File> getSrcDirs() {
        return this.mySrcDirs;
    }

    public void setSrcDirs(@NotNull Set<File> srcDirs) {
        this.mySrcDirs = srcDirs;
    }

    @NotNull
    public File getOutputDir() {
        return this.myOutputDir;
    }

    public void setOutputDir(@NotNull File outputDir) {
        this.myOutputDir = outputDir;
    }

    @NotNull
    public File getGradleOutputDir() {
        assert (this.myGradleOutputDirs.size() > 0);
        return this.myGradleOutputDirs.get(0);
    }

    @NotNull
    public Collection<File> getGradleOutputDirs() {
        return this.myGradleOutputDirs;
    }

    public void addGradleOutputDir(@NotNull File outputDir) {
        this.myGradleOutputDirs.add(outputDir);
    }

    public boolean isCompilerOutputPathInherited() {
        return this.myInheritedCompilerOutput;
    }

    @NotNull
    public Set<String> getExcludes() {
        return this.myPatterns.getExcludes();
    }

    public void setExcludes(Set<String> excludes) {
        this.myPatterns.getExcludes().clear();
        this.myPatterns.getExcludes().addAll(excludes);
    }

    @NotNull
    public Set<String> getIncludes() {
        return this.myPatterns.getIncludes();
    }

    public void setIncludes(Set<String> includes) {
        this.myPatterns.getIncludes().clear();
        this.myPatterns.getIncludes().addAll(includes);
    }

    @NotNull
    public FilePatternSet getPatterns() {
        return this.myPatterns;
    }

    public void setInheritedCompilerOutput(boolean inheritedCompilerOutput) {
        this.myInheritedCompilerOutput = inheritedCompilerOutput;
    }

    @NotNull
    public List<ExternalFilter> getFilters() {
        return this.myFilters;
    }

    public void setFilters(@NotNull List<ExternalFilter> filters) {
        this.myFilters = filters;
    }
}

