/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.tests;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.tests.ExternalTestSourceMapping;

public class DefaultExternalTestSourceMapping
implements ExternalTestSourceMapping {
    @Nullable
    private String testName = null;
    @Nullable
    private String testTaskPath = null;
    @Nullable
    private String cleanTestTaskPath = null;
    @NotNull
    private Set<String> sourceFolders = Collections.emptySet();

    public DefaultExternalTestSourceMapping() {
    }

    public DefaultExternalTestSourceMapping(@NotNull ExternalTestSourceMapping externalTestSourceMapping) {
        this.testName = externalTestSourceMapping.getTestName();
        this.testTaskPath = externalTestSourceMapping.getTestTaskPath();
        this.cleanTestTaskPath = externalTestSourceMapping.getCleanTestTaskPath();
        this.sourceFolders = new LinkedHashSet<String>(externalTestSourceMapping.getSourceFolders());
    }

    @NotNull
    public Set<String> getSourceFolders() {
        return Collections.unmodifiableSet(this.sourceFolders);
    }

    public void setSourceFolders(@NotNull Set<String> sourceFolders) {
        this.sourceFolders = sourceFolders;
    }

    @NotNull
    public String getTestName() {
        assert (this.testName != null);
        return this.testName;
    }

    public void setTestName(@Nullable String testName) {
        this.testName = testName;
    }

    @NotNull
    public String getTestTaskPath() {
        assert (this.testTaskPath != null);
        return this.testTaskPath;
    }

    public void setTestTaskPath(@NotNull String testTaskPath) {
        this.testTaskPath = testTaskPath;
    }

    @NotNull
    public String getCleanTestTaskPath() {
        assert (this.cleanTestTaskPath != null);
        return this.cleanTestTaskPath;
    }

    public void setCleanTestTaskPath(@NotNull String cleanTestTaskPath) {
        this.cleanTestTaskPath = cleanTestTaskPath;
    }
}

