/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.builder.IdeaModuleDirectorySet;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaCompilerOutputImpl;
import org.jetbrains.plugins.gradle.tooling.internal.IdeaContentRootImpl;
import org.jetbrains.plugins.gradle.tooling.internal.ModuleExtendedModelImpl;

@Deprecated
public class ModuleExtendedModelBuilderImpl
implements ModelBuilderService {
    private static final boolean is4OorBetter = GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version((String)"4.0")) >= 0;
    private static final boolean is22orBetter = GradleVersion.current().compareTo(GradleVersion.version((String)"2.2")) >= 0;
    public static final boolean is50OrBetter = GradleVersion.current().compareTo(GradleVersion.version((String)"5.0")) >= 0;
    private static final String SOURCE_SETS_PROPERTY = "sourceSets";
    private static final String TEST_SRC_DIRS_PROPERTY = "testSrcDirs";

    public boolean canBuild(String modelName) {
        return ModuleExtendedModel.class.getName().equals(modelName);
    }

    @Nullable
    public Object buildAll(String modelName, Project project) {
        Object sourceSets;
        String moduleName = project.getName();
        String moduleGroup = project.getGroup().toString();
        String moduleVersion = project.getVersion().toString();
        File buildDir = project.getBuildDir();
        String javaSourceCompatibility = null;
        for (Task task : project.getTasks()) {
            if (!(task instanceof JavaCompile)) continue;
            JavaCompile javaCompile = (JavaCompile)task;
            javaSourceCompatibility = javaCompile.getSourceCompatibility();
            if (!task.getName().equals("compileJava")) continue;
            break;
        }
        ModuleExtendedModelImpl moduleVersionModel = new ModuleExtendedModelImpl(moduleName, moduleGroup, moduleVersion, buildDir, javaSourceCompatibility);
        ArrayList<File> artifacts = new ArrayList<File>();
        for (Task task : project.getTasks()) {
            if (!(task instanceof Jar)) continue;
            Jar jar = (Jar)task;
            try {
                artifacts.add(jar.getArchivePath());
            }
            catch (Exception e) {
                project.getLogger().error("warning: [task " + jar.getPath() + "] " + e.getMessage());
            }
        }
        moduleVersionModel.setArtifacts(artifacts);
        IdeaModuleDirectorySet directorySet = new IdeaModuleDirectorySet();
        ArrayList<File> testClassesDirs = new ArrayList<File>();
        for (Task task : project.getTasks()) {
            Object testSrcDirs;
            if (!(task instanceof Test)) continue;
            Test test = (Test)task;
            if (is4OorBetter) {
                testClassesDirs.addAll(test.getTestClassesDirs().getFiles());
            } else {
                testClassesDirs.add(test.getTestClassesDir());
            }
            if (!test.hasProperty(TEST_SRC_DIRS_PROPERTY) || !((testSrcDirs = test.property(TEST_SRC_DIRS_PROPERTY)) instanceof Iterable)) continue;
            for (Object dir : (Iterable)testSrcDirs) {
                ModuleExtendedModelBuilderImpl.addFilePath(directorySet.getTestDirectories(), dir);
            }
        }
        IdeaCompilerOutputImpl compilerOutput = new IdeaCompilerOutputImpl();
        if (project.hasProperty(SOURCE_SETS_PROPERTY) && (sourceSets = project.property(SOURCE_SETS_PROPERTY)) instanceof SourceSetContainer) {
            SourceSetContainer sourceSetContainer = (SourceSetContainer)sourceSets;
            for (SourceSet sourceSet : sourceSetContainer) {
                boolean isTestDir;
                Iterator firstClassesDir;
                SourceSetOutput output = sourceSet.getOutput();
                if ("test".equals(sourceSet.getName())) {
                    if (is4OorBetter) {
                        firstClassesDir = (File)CollectionUtils.findFirst((Iterable)output.getClassesDirs().getFiles(), (Spec)Specs.SATISFIES_ALL);
                        compilerOutput.setTestClassesDir((File)((Object)firstClassesDir));
                    } else {
                        compilerOutput.setTestClassesDir(output.getClassesDir());
                    }
                    compilerOutput.setTestResourcesDir(output.getResourcesDir());
                }
                if ("main".equals(sourceSet.getName())) {
                    if (is4OorBetter) {
                        firstClassesDir = (File)CollectionUtils.findFirst((Iterable)output.getClassesDirs().getFiles(), (Spec)Specs.SATISFIES_ALL);
                        compilerOutput.setMainClassesDir((File)((Object)firstClassesDir));
                    } else {
                        compilerOutput.setMainClassesDir(output.getClassesDir());
                    }
                    compilerOutput.setMainResourcesDir(output.getResourcesDir());
                }
                for (File javaSrcDir : sourceSet.getAllJava().getSrcDirs()) {
                    isTestDir = ModuleExtendedModelBuilderImpl.isTestDir(sourceSet, testClassesDirs);
                    ModuleExtendedModelBuilderImpl.addFilePath(isTestDir ? directorySet.getTestDirectories() : directorySet.getSourceDirectories(), javaSrcDir);
                }
                for (File resourcesSrcDir : sourceSet.getResources().getSrcDirs()) {
                    isTestDir = ModuleExtendedModelBuilderImpl.isTestDir(sourceSet, testClassesDirs);
                    ModuleExtendedModelBuilderImpl.addFilePath(isTestDir ? directorySet.getTestResourceDirectories() : directorySet.getResourceDirectories(), resourcesSrcDir);
                }
            }
        }
        File projectDir = project.getProjectDir();
        IdeaContentRootImpl contentRoot = new IdeaContentRootImpl(projectDir);
        IdeaModuleDirectorySet ideaPluginConfig = ModuleExtendedModelBuilderImpl.extractDataFromIdeaPlugin(project);
        directorySet.mergeFrom(ideaPluginConfig);
        directorySet.fill(contentRoot);
        moduleVersionModel.setContentRoots(Collections.singleton(contentRoot));
        moduleVersionModel.setCompilerOutput(compilerOutput);
        ConfigurationContainer configurations = project.getConfigurations();
        SortedMap configurationsByName = configurations.getAsMap();
        HashMap<String, Set<File>> artifactsByConfiguration = new HashMap<String, Set<File>>();
        for (Map.Entry configurationEntry : configurationsByName.entrySet()) {
            Set files = ((Configuration)configurationEntry.getValue()).getAllArtifacts().getFiles().getFiles();
            artifactsByConfiguration.put((String)configurationEntry.getKey(), new LinkedHashSet(files));
        }
        moduleVersionModel.setArtifactsByConfiguration(artifactsByConfiguration);
        return moduleVersionModel;
    }

    @NotNull
    public ErrorMessageBuilder getErrorMessageBuilder(@NotNull Project project, @NotNull Exception e) {
        return ErrorMessageBuilder.create((Project)project, (Exception)e, (String)"Other").withDescription("Unable to resolve all content root directories");
    }

    private static boolean isTestDir(SourceSet sourceSet, List<File> testClassesDirs) {
        if ("test".equals(sourceSet.getName())) {
            return true;
        }
        if ("main".equals(sourceSet.getName())) {
            return false;
        }
        File sourceSetClassesDir = is4OorBetter ? (File)CollectionUtils.findFirst((Iterable)sourceSet.getOutput().getClassesDirs().getFiles(), (Spec)Specs.SATISFIES_ALL) : sourceSet.getOutput().getClassesDir();
        for (File testClassesDir : testClassesDirs) {
            do {
                if (!sourceSetClassesDir.getPath().equals(testClassesDir.getPath())) continue;
                return true;
            } while ((testClassesDir = testClassesDir.getParentFile()) != null);
        }
        return false;
    }

    private static void addFilePath(Set<String> filePathSet, Object file) {
        if (file instanceof File) {
            try {
                filePathSet.add(((File)file).getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static IdeaModuleDirectorySet extractDataFromIdeaPlugin(Project project) {
        IdeaModuleDirectorySet result = new IdeaModuleDirectorySet();
        IdeaPlugin ideaPlugin = (IdeaPlugin)project.getPlugins().findPlugin(IdeaPlugin.class);
        if (ideaPlugin == null) {
            return result;
        }
        IdeaModel ideaModel = ideaPlugin.getModel();
        if (ideaModel == null) {
            return result;
        }
        IdeaModule module = ideaModel.getModule();
        if (module == null) {
            return result;
        }
        result.getExcludedDirectories().addAll(module.getExcludeDirs());
        for (File file : module.getSourceDirs()) {
            result.getSourceDirectories().add(file.getPath());
        }
        for (File file : module.getTestSourceDirs()) {
            result.getTestDirectories().add(file.getPath());
        }
        if (is50OrBetter) {
            for (File file : module.getResourceDirs()) {
                result.getResourceDirectories().add(file.getPath());
            }
            for (File file : module.getTestResourceDirs()) {
                result.getTestResourceDirectories().add(file.getPath());
            }
        }
        if (is22orBetter) {
            for (File file : module.getGeneratedSourceDirs()) {
                result.getGeneratedSourceDirectories().add(file.getPath());
            }
        }
        return result;
    }
}

