/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.plugins.gradle.model.ExternalDependency;

public class DependencyTraverser
implements Iterable<ExternalDependency> {
    private final Collection<ExternalDependency> collection;

    public DependencyTraverser(Collection<ExternalDependency> c) {
        this.collection = c;
    }

    @Override
    public Iterator<ExternalDependency> iterator() {
        return new Itr(this.collection);
    }

    private static class Itr
    implements Iterator<ExternalDependency> {
        Queue<ExternalDependency> queue;

        Itr(Collection<ExternalDependency> c) {
            this.queue = new LinkedList<ExternalDependency>(c);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public ExternalDependency next() {
            ExternalDependency dependency = this.queue.remove();
            this.queue.addAll(dependency.getDependencies());
            return dependency;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

