/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.util.resolve;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.component.Component;
import org.gradle.api.specs.Specs;
import org.gradle.internal.impldep.com.google.common.collect.ArrayListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Multimap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.language.base.artifact.SourcesArtifact;
import org.gradle.language.java.artifact.JavadocArtifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.tooling.util.SourceSetCachedFinder;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResolverImpl;
import org.jetbrains.plugins.gradle.tooling.util.resolve.DependencyResultsTransformer;
import org.jetbrains.plugins.gradle.tooling.util.resolve.ExternalDepsResolutionResult;

class ArtifactQueryResolver {
    private final Configuration myConfiguration;
    private final String myScope;
    private final Project myProject;
    private final boolean myDownloadSources;
    private final boolean myDownloadJavadoc;
    private final SourceSetCachedFinder mySourceSetFinder;

    ArtifactQueryResolver(@NotNull Configuration configuration, @Nullable String scope, @NotNull Project project, boolean downloadJavadoc, boolean downloadSources, @NotNull SourceSetCachedFinder sourceSetFinder) {
        this.myConfiguration = configuration;
        this.myScope = scope;
        this.myProject = project;
        this.myDownloadJavadoc = downloadJavadoc;
        this.myDownloadSources = downloadSources;
        this.mySourceSetFinder = sourceSetFinder;
    }

    public ExternalDepsResolutionResult resolve() {
        LinkedHashSet<ResolvedArtifact> resolvedArtifacts;
        LinkedHashSet<ExternalDependency> extDependencies = new LinkedHashSet<ExternalDependency>();
        Class<? extends Component> jvmLibrary = this.tryLoadingJvmLibraryClass();
        if (jvmLibrary == null) {
            return ExternalDepsResolutionResult.EMPTY;
        }
        LenientConfiguration lenientConfiguration = this.myConfiguration.getResolvedConfiguration().getLenientConfiguration();
        Set unresolvedModuleDependencies = lenientConfiguration.getUnresolvedModuleDependencies();
        if (unresolvedModuleDependencies.isEmpty() || !DependencyResolverImpl.is31OrBetter) {
            resolvedArtifacts = lenientConfiguration.getArtifacts(Specs.SATISFIES_ALL);
        } else {
            resolvedArtifacts = new LinkedHashSet<ResolvedArtifact>();
            Set allModuleDependencies = lenientConfiguration.getAllModuleDependencies();
            for (ResolvedDependency dependency : allModuleDependencies) {
                try {
                    resolvedArtifacts.addAll(dependency.getModuleArtifacts());
                }
                catch (Exception exception) {}
            }
        }
        Multimap<ModuleVersionIdentifier, ResolvedArtifact> artifactMap = this.groupByModuleVersionId(resolvedArtifacts);
        Map<ComponentIdentifier, ComponentArtifactsResult> auxiliaryArtifactsMap = this.buildAuxiliaryArtifactsMap(jvmLibrary, resolvedArtifacts);
        Multimap<ModuleComponentIdentifier, ProjectDependency> configurationProjectDependencies = DependencyResolverImpl.collectProjectDeps(this.myConfiguration);
        if (!this.myConfiguration.getResolvedConfiguration().hasError()) {
            extDependencies.addAll(this.buildFileCollectionDeps(resolvedArtifacts, configurationProjectDependencies.values()));
        }
        DependencyResultsTransformer dependencyResultsTransformer = new DependencyResultsTransformer(this.myProject, this.mySourceSetFinder, artifactMap, auxiliaryArtifactsMap, configurationProjectDependencies, this.myScope);
        ResolutionResult resolutionResult = this.myConfiguration.getIncoming().getResolutionResult();
        extDependencies.addAll(dependencyResultsTransformer.buildExternalDependencies(resolutionResult.getRoot().getDependencies()));
        return new ExternalDepsResolutionResult(extDependencies, new ArrayList<File>(dependencyResultsTransformer.getResolvedDepsFiles()));
    }

    @NotNull
    public Multimap<ModuleVersionIdentifier, ResolvedArtifact> groupByModuleVersionId(Set<ResolvedArtifact> resolvedArtifacts) {
        ArrayListMultimap artifactMap = ArrayListMultimap.create();
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            ModuleVersionIdentifier moduleVersionId = artifact.getModuleVersion().getId();
            artifactMap.put((Object)moduleVersionId, (Object)artifact);
        }
        return artifactMap;
    }

    @NotNull
    public Map<ComponentIdentifier, ComponentArtifactsResult> buildAuxiliaryArtifactsMap(@NotNull Class<? extends Component> jvmLibrary, @NotNull Set<ResolvedArtifact> resolvedArtifacts) {
        ArrayList<ModuleComponentIdentifier> components = new ArrayList<ModuleComponentIdentifier>();
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            ModuleVersionIdentifier moduleVersionId = artifact.getModuleVersion().getId();
            if (DependencyResolverImpl.isProjectDependencyArtifact(artifact)) continue;
            components.add(DependencyResolverImpl.toComponentIdentifier(moduleVersionId));
        }
        boolean isBuildScriptConfiguration = this.myProject.getBuildscript().getConfigurations().contains((Object)this.myConfiguration);
        DependencyHandler dependencyHandler = isBuildScriptConfiguration ? this.myProject.getBuildscript().getDependencies() : this.myProject.getDependencies();
        Set componentResults = dependencyHandler.createArtifactResolutionQuery().forComponents(components).withArtifacts(jvmLibrary, this.additionalArtifactsTypes().toArray(new Class[0])).execute().getResolvedComponents();
        HashMap<ComponentIdentifier, ComponentArtifactsResult> componentResultsMap = new HashMap<ComponentIdentifier, ComponentArtifactsResult>();
        for (ComponentArtifactsResult artifactsResult : componentResults) {
            componentResultsMap.put(artifactsResult.getId(), artifactsResult);
        }
        return componentResultsMap;
    }

    protected Collection<ExternalDependency> buildFileCollectionDeps(Collection<ResolvedArtifact> resolvedArtifactToFilter, Collection<ProjectDependency> projectDepsToFilter) {
        ArrayList<ExternalDependency> result = new ArrayList<ExternalDependency>();
        LinkedHashSet fileDeps = new LinkedHashSet(this.myConfiguration.getIncoming().getFiles().getFiles());
        for (ResolvedArtifact artifact : resolvedArtifactToFilter) {
            fileDeps.remove(artifact.getFile());
        }
        if (!fileDeps.isEmpty()) {
            for (ProjectDependency dep : projectDepsToFilter) {
                Set depFiles;
                LinkedHashSet<File> intersection;
                Configuration targetConfiguration = DependencyResolverImpl.getTargetConfiguration(dep);
                if (targetConfiguration == null || (intersection = new LinkedHashSet<File>((Collection<File>)Sets.intersection(fileDeps, (Set)(depFiles = targetConfiguration.getAllArtifacts().getFiles().getFiles())))).isEmpty()) continue;
                DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(intersection);
                fileCollectionDependency.setScope(this.myScope);
                result.add(fileCollectionDependency);
                fileDeps.removeAll(intersection);
            }
        }
        for (File file : fileDeps) {
            DefaultFileCollectionDependency fileCollectionDependency = new DefaultFileCollectionDependency(Collections.singleton(file));
            fileCollectionDependency.setScope(this.myScope);
            result.add(fileCollectionDependency);
        }
        return result;
    }

    @NotNull
    protected List<Class<? extends Artifact>> additionalArtifactsTypes() {
        ArrayList<Class<? extends Artifact>> artifactTypes = new ArrayList<Class<? extends Artifact>>();
        if (this.myDownloadSources) {
            artifactTypes.add(SourcesArtifact.class);
        }
        if (this.myDownloadJavadoc) {
            artifactTypes.add(JavadocArtifact.class);
        }
        return artifactTypes;
    }

    @Nullable
    protected Class<? extends Component> tryLoadingJvmLibraryClass() {
        Class<?> jvmLibrary = null;
        try {
            jvmLibrary = Class.forName("org.gradle.jvm.JvmLibrary");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (jvmLibrary == null) {
            try {
                jvmLibrary = Class.forName("org.gradle.runtime.jvm.JvmLibrary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return jvmLibrary;
    }
}

