/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaAnnotationUtil {
    private static final TObjectHashingStrategy<PsiClass> HASHING_STRATEGY = new TObjectHashingStrategy<PsiClass>(){

        public int computeHashCode(PsiClass object) {
            String qualifiedName = object.getQualifiedName();
            return qualifiedName == null ? 0 : qualifiedName.hashCode();
        }

        public boolean equals(PsiClass o1, PsiClass o2) {
            return Comparing.equal((String)o1.getQualifiedName(), (String)o2.getQualifiedName());
        }
    };

    public static Collection<PsiClass> getAnnotationTypesWithChildren(@NotNull Module module, String annotationName, boolean includeTests) {
        Project project = module.getProject();
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap factoryMap = ConcurrentFactoryMap.createMap(key -> {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)((Boolean)key.getSecond()));
                PsiClass annotationClass = JavaPsiFacade.getInstance(project).findClass((String)key.getFirst(), moduleScope);
                if (annotationClass == null || !annotationClass.isAnnotationType()) {
                    return Collections.emptyList();
                }
                GlobalSearchScope effectiveSearchScope = MetaAnnotationUtil.getAllAnnotationFilesScope(project).intersectWith(moduleScope);
                return MetaAnnotationUtil.getAnnotationTypesWithChildren(annotationClass, effectiveSearchScope);
            });
            return CachedValueProvider.Result.create((Object)factoryMap, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        return (Collection)map.get(Pair.pair((Object)annotationName, (Object)includeTests));
    }

    public static Set<PsiClass> getChildren(@NotNull PsiClass psiClass, @NotNull GlobalSearchScope scope) {
        if (AnnotationTargetUtil.findAnnotationTarget(psiClass, PsiAnnotation.TargetType.ANNOTATION_TYPE, PsiAnnotation.TargetType.TYPE) == null) {
            return Collections.emptySet();
        }
        String name = psiClass.getQualifiedName();
        if (name == null) {
            return Collections.emptySet();
        }
        THashSet result = new THashSet(HASHING_STRATEGY);
        AnnotatedElementsSearch.searchPsiClasses(psiClass, (SearchScope)scope).forEach(arg_0 -> MetaAnnotationUtil.lambda$getChildren$2((Set)result, arg_0));
        return result;
    }

    public static Collection<PsiClass> getAnnotatedTypes(@NotNull Module module, @NotNull Key<CachedValue<Collection<PsiClass>>> key, @NotNull String annotationName) {
        return (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, key, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            PsiClass psiClass = JavaPsiFacade.getInstance(module.getProject()).findClass(annotationName, scope);
            Collection<Object> classes = psiClass == null || !psiClass.isAnnotationType() ? Collections.emptyList() : MetaAnnotationUtil.getChildren(psiClass, scope);
            return new CachedValueProvider.Result(classes, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        }, false);
    }

    @NotNull
    private static Collection<PsiClass> getAnnotationTypesWithChildren(PsiClass annotationClass, GlobalSearchScope scope) {
        THashSet classes = new THashSet(HASHING_STRATEGY);
        MetaAnnotationUtil.collectClassWithChildren(annotationClass, (Set<? super PsiClass>)classes, scope);
        return classes;
    }

    private static GlobalSearchScope getAllAnnotationFilesScope(Project project) {
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            HashSet allAnnotationFiles = new HashSet();
            for (PsiClass javaLangAnnotation : JavaPsiFacade.getInstance(project).findClasses("java.lang.annotation.Annotation", scope)) {
                DirectClassInheritorsSearch.search(javaLangAnnotation, (SearchScope)scope, false).forEach(annotationClass -> {
                    ProgressManager.checkCanceled();
                    ContainerUtil.addIfNotNull((Collection)allAnnotationFiles, (Object)PsiUtilCore.getVirtualFile((PsiElement)annotationClass));
                    return true;
                });
            }
            scope = GlobalSearchScope.filesWithLibrariesScope((Project)project, allAnnotationFiles);
            return CachedValueProvider.Result.createSingleDependency((Object)scope, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
    }

    private static void collectClassWithChildren(PsiClass psiClass, Set<? super PsiClass> classes, GlobalSearchScope scope) {
        classes.add(psiClass);
        for (PsiClass aClass : MetaAnnotationUtil.getChildren(psiClass, scope)) {
            if (classes.contains(aClass)) continue;
            MetaAnnotationUtil.collectClassWithChildren(aClass, classes, scope);
        }
    }

    public static boolean isMetaAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        if (AnnotationUtil.isAnnotated(listOwner, annotations, 0)) {
            return true;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner);
        for (String annotationFQN : annotations) {
            for (PsiClass resolvedAnnotation : resolvedAnnotations) {
                if (MetaAnnotationUtil.metaAnnotationCached(resolvedAnnotation, annotationFQN) == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        return MetaAnnotationUtil.isMetaAnnotatedInHierarchy(listOwner, annotations, new HashSet());
    }

    private static boolean isMetaAnnotatedInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations, Set<? super PsiMember> visited) {
        block4: {
            block3: {
                if (MetaAnnotationUtil.isMetaAnnotated(listOwner, annotations)) {
                    return true;
                }
                if (!(listOwner instanceof PsiClass)) break block3;
                for (PsiClass superClass : ((PsiClass)listOwner).getSupers()) {
                    if (!visited.add(superClass) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy(superClass, annotations, visited)) continue;
                    return true;
                }
                break block4;
            }
            if (!(listOwner instanceof PsiMethod)) break block4;
            for (PsiMethod method : ((PsiMethod)listOwner).findSuperMethods()) {
                if (!visited.add(method) || !MetaAnnotationUtil.isMetaAnnotatedInHierarchy(method, annotations, visited)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiAnnotation metaAnnotationCached(PsiClass subjectAnnotation, String annotationToFind) {
        return (PsiAnnotation)((ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)subjectAnnotation, () -> {
            ConcurrentMap metaAnnotationsMap = ConcurrentFactoryMap.createMap(anno -> MetaAnnotationUtil.findMetaAnnotation(subjectAnnotation, anno, new HashSet()));
            return new CachedValueProvider.Result((Object)metaAnnotationsMap, new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        })).get(annotationToFind);
    }

    @Nullable
    private static PsiAnnotation findMetaAnnotation(PsiClass aClass, String annotation, Set<? super PsiClass> visited) {
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, true, annotation);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        List<PsiClass> resolvedAnnotations = MetaAnnotationUtil.getResolvedClassesInAnnotationsList(aClass);
        for (PsiClass resolvedAnnotation : resolvedAnnotations) {
            PsiAnnotation annotated;
            if (!visited.add(resolvedAnnotation) || (annotated = MetaAnnotationUtil.findMetaAnnotation(resolvedAnnotation, annotation, visited)) == null) continue;
            return annotated;
        }
        return null;
    }

    @NotNull
    public static Stream<PsiAnnotation> findMetaAnnotations(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations) {
        Stream<PsiAnnotation> directAnnotations = Stream.of(AnnotationUtil.findAnnotations(listOwner, annotations));
        Stream lazyResolvedAnnotations = Stream.generate(() -> MetaAnnotationUtil.getResolvedClassesInAnnotationsList(listOwner)).limit(1L).flatMap(it -> it.stream());
        Stream<PsiAnnotation> metaAnnotations = lazyResolvedAnnotations.flatMap(psiClass -> annotations.stream().map(annotationFQN -> MetaAnnotationUtil.metaAnnotationCached(psiClass, annotationFQN))).filter(Objects::nonNull);
        return Stream.concat(directAnnotations, metaAnnotations);
    }

    private static List<PsiClass> getResolvedClassesInAnnotationsList(PsiModifierListOwner owner) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            return ContainerUtil.mapNotNull((Object[])modifierList.getApplicableAnnotations(), psiAnnotation -> {
                PsiJavaCodeReferenceElement nameReferenceElement = psiAnnotation.getNameReferenceElement();
                PsiElement resolve = nameReferenceElement != null ? nameReferenceElement.resolve() : null;
                return resolve instanceof PsiClass && ((PsiClass)resolve).isAnnotationType() ? (PsiClass)resolve : null;
            });
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ boolean lambda$getChildren$2(Set result, PsiClass processorResult) {
        ProgressManager.checkCanceled();
        if (processorResult.isAnnotationType()) {
            result.add(processorResult);
        }
        return true;
    }
}

