/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CheckerFrameworkNullityUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableNotNullManager {
    protected static final Logger LOG = Logger.getInstance(NullableNotNullManager.class);
    protected final Project myProject;
    protected static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    protected static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";
    static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "javax.annotation.CheckForNull", "edu.umd.cs.findbugs.annotations.Nullable", "android.support.annotation.Nullable", "androidx.annotation.Nullable", "android.annotation.Nullable", "androidx.annotation.RecentlyNullable", "org.checkerframework.checker.nullness.qual.Nullable", "org.checkerframework.checker.nullness.compatqual.NullableDecl", "org.checkerframework.checker.nullness.compatqual.NullableType", "com.android.annotations.Nullable"};
    static final String[] DEFAULT_NOT_NULLS = new String[]{"org.jetbrains.annotations.NotNull", "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull", "android.support.annotation.NonNull", "androidx.annotation.NonNull", "android.annotation.NonNull", "androidx.annotation.RecentlyNonNull", "org.checkerframework.checker.nullness.qual.NonNull", "org.checkerframework.checker.nullness.compatqual.NonNullDecl", "org.checkerframework.checker.nullness.compatqual.NonNullType", "com.android.annotations.NonNull"};
    private static final List<String> DEFAULT_ALL = Arrays.asList(ArrayUtil.mergeArrays((String[])DEFAULT_NULLABLES, (String[])DEFAULT_NOT_NULLS));

    protected NullableNotNullManager(Project project) {
        this.myProject = project;
    }

    public static NullableNotNullManager getInstance(Project project) {
        return (NullableNotNullManager)ServiceManager.getService((Project)project, NullableNotNullManager.class);
    }

    public boolean hasNullability(@NotNull PsiModifierListOwner owner) {
        return this.isNullable(owner, false) || this.isNotNull(owner, false);
    }

    public abstract void setNotNulls(String ... var1);

    public abstract void setNullables(String ... var1);

    @NotNull
    public abstract String getDefaultNullable();

    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullityAnnotationWithDefault(owner, checkBases, true);
    }

    public abstract void setDefaultNullable(@NotNull String var1);

    @NotNull
    public abstract String getDefaultNotNull();

    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullityAnnotationWithDefault(owner, checkBases, false);
    }

    @Nullable
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info = this.findOwnNullabilityInfo(original);
        if (info == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info = this.findOwnNullabilityInfo(original);
        if (info == null || info.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo src = this.findOwnNullabilityInfo(original);
        if (src == null) {
            return null;
        }
        NullabilityAnnotationInfo effective = this.findEffectiveNullabilityInfo(generated);
        if (effective != null && effective.getNullability() == src.getNullability()) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(src.getAnnotation(), generated);
    }

    @Nullable
    private static PsiAnnotation copyAnnotation(@NotNull PsiAnnotation annotation, @NotNull PsiModifierListOwner target) {
        String qualifiedName = annotation.getQualifiedName();
        if (qualifiedName != null) {
            PsiModifierList modifierList;
            if (JavaPsiFacade.getInstance(annotation.getProject()).findClass(qualifiedName, target.getResolveScope()) == null) {
                return null;
            }
            if (!AnnotationTargetUtil.isTypeAnnotation(annotation) && (modifierList = target.getModifierList()) != null && !modifierList.hasAnnotation(qualifiedName)) {
                return modifierList.addAnnotation(qualifiedName);
            }
        }
        return null;
    }

    @Deprecated
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info = this.findOwnNullabilityInfo(owner);
        if (info == null || info.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(owner, info.getAnnotation());
    }

    private static PsiAnnotation copyAnnotation(@NotNull PsiModifierListOwner owner, @NotNull PsiAnnotation annotation) {
        String qualifiedName = annotation.getQualifiedName();
        return qualifiedName != null ? JavaPsiFacade.getElementFactory(owner.getProject()).createAnnotationFromText("@" + qualifiedName, owner) : null;
    }

    public abstract void setDefaultNotNull(@NotNull String var1);

    @Nullable
    private PsiAnnotation findNullityAnnotationWithDefault(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        List<PsiParameter> superParameters;
        int flags;
        PsiAnnotation annotation = this.findPlainNullityAnnotation(owner, checkBases);
        if (annotation != null) {
            List<String> contradictory;
            String qName = annotation.getQualifiedName();
            if (qName == null) {
                return null;
            }
            List<String> list = contradictory = nullable ? this.getNotNullsWithNickNames() : this.getNullablesWithNickNames();
            if (contradictory.contains(qName)) {
                return null;
            }
            return annotation;
        }
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        List<String> annotations = Arrays.asList(nullable ? DEFAULT_NOT_NULLS : DEFAULT_NULLABLES);
        if (AnnotationUtil.isAnnotated(owner, annotations, flags = (checkBases ? 1 : 0) | 2 | 4 | 8)) {
            return null;
        }
        if (!nullable && this.hasHardcodedContracts(owner)) {
            return null;
        }
        if (owner instanceof PsiParameter && !nullable && checkBases && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            return this.takeAnnotationFromSuperParameters((PsiParameter)owner, superParameters);
        }
        NullabilityAnnotationInfo nullityDefault = this.findNullityDefaultInHierarchy(owner);
        Nullability wantedNullability = nullable ? Nullability.NULLABLE : Nullability.NOT_NULL;
        return nullityDefault != null && nullityDefault.getNullability() == wantedNullability ? nullityDefault.getAnnotation() : null;
    }

    @Nullable
    public NullabilityAnnotationInfo findOwnNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        List<String> nullables = this.getNullablesWithNickNames();
        HashSet annotationNames = ContainerUtil.newHashSet(nullables);
        annotationNames.addAll(this.getNotNullsWithNickNames());
        PsiAnnotation annotation = this.findPlainNullityAnnotation(owner, false);
        if (annotation != null) {
            return new NullabilityAnnotationInfo(annotation, nullables.contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        return null;
    }

    @Nullable
    public NullabilityAnnotationInfo findEffectiveNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (type == null || TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return null;
        }
        return (NullabilityAnnotationInfo)CachedValuesManager.getCachedValue((PsiElement)owner, () -> CachedValueProvider.Result.create((Object)this.doFindEffectiveNullabilityAnnotation(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @Nullable
    private NullabilityAnnotationInfo doFindEffectiveNullabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        List<PsiParameter> superParameters;
        List<String> nullables = this.getNullablesWithNickNames();
        HashSet annotationNames = ContainerUtil.newHashSet(nullables);
        annotationNames.addAll(this.getNotNullsWithNickNames());
        Set extraAnnotations = DEFAULT_ALL.stream().filter(anno -> !annotationNames.contains(anno)).collect(Collectors.toSet());
        annotationNames.addAll(extraAnnotations);
        PsiAnnotation annotation = NullableNotNullManager.findPlainAnnotation(owner, true, annotationNames);
        if (annotation != null) {
            if (extraAnnotations.contains(annotation.getQualifiedName())) {
                return null;
            }
            return new NullabilityAnnotationInfo(annotation, nullables.contains(annotation.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        if (owner instanceof PsiParameter && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            for (PsiParameter parameter : superParameters) {
                PsiAnnotation plain = NullableNotNullManager.findPlainAnnotation(parameter, false, annotationNames);
                if (plain != null) {
                    return null;
                }
                NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(parameter);
                if (defaultInfo == null) continue;
                return defaultInfo.getNullability() == Nullability.NOT_NULL ? defaultInfo : null;
            }
            return null;
        }
        NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(owner);
        if (!(defaultInfo == null || defaultInfo.getNullability() != Nullability.NULLABLE && this.hasHardcodedContracts(owner))) {
            return defaultInfo;
        }
        return null;
    }

    private PsiAnnotation takeAnnotationFromSuperParameters(@NotNull PsiParameter owner, @NotNull List<PsiParameter> superOwners) {
        return (PsiAnnotation)RecursionManager.doPreventingRecursion((Object)owner, (boolean)true, () -> {
            for (PsiParameter superOwner : superOwners) {
                PsiAnnotation anno = this.findNullityAnnotationWithDefault(superOwner, false, false);
                if (anno == null) continue;
                return anno;
            }
            return null;
        });
    }

    private PsiAnnotation findPlainNullityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        HashSet qNames = ContainerUtil.newHashSet(this.getNullablesWithNickNames());
        qNames.addAll(this.getNotNullsWithNickNames());
        return NullableNotNullManager.findPlainAnnotation(owner, checkBases, qNames);
    }

    @Nullable
    private static PsiAnnotation findPlainAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases, @NotNull Set<String> qualifiedNames) {
        PsiAnnotation memberAnno = checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationInHierarchy(owner, qualifiedNames) : AnnotationUtil.findAnnotation(owner, qualifiedNames);
        PsiType type = NullableNotNullManager.getOwnerType(owner);
        if (memberAnno != null) {
            return NullableNotNullManager.preferTypeAnnotation(memberAnno, type);
        }
        if (type != null) {
            return (PsiAnnotation)ContainerUtil.find((Object[])type.getAnnotations(), a -> qualifiedNames.contains(a.getQualifiedName()));
        }
        return null;
    }

    @NotNull
    private static PsiAnnotation preferTypeAnnotation(@NotNull PsiAnnotation memberAnno, @Nullable PsiType type) {
        if (type != null) {
            for (PsiAnnotation typeAnno : type.getApplicableAnnotations()) {
                if (!NullableNotNullManager.areDifferentNullityAnnotations(memberAnno, typeAnno)) continue;
                return typeAnno;
            }
        }
        return memberAnno;
    }

    private static boolean areDifferentNullityAnnotations(@NotNull PsiAnnotation memberAnno, @NotNull PsiAnnotation typeAnno) {
        return NullableNotNullManager.isNullableAnnotation(typeAnno) && NullableNotNullManager.isNotNullAnnotation(memberAnno) || NullableNotNullManager.isNullableAnnotation(memberAnno) && NullableNotNullManager.isNotNullAnnotation(typeAnno);
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        return this.getNullables();
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        return this.getNotNulls();
    }

    protected boolean hasHardcodedContracts(@NotNull PsiElement element) {
        return false;
    }

    @Nullable
    private static PsiType getOwnerType(@NotNull PsiModifierListOwner owner) {
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullityAnnotationWithDefault(owner, checkBases, true) != null;
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        return this.findNullityAnnotationWithDefault(owner, checkBases, false) != null;
    }

    @Nullable
    NullabilityAnnotationInfo findNullityDefaultInHierarchy(@NotNull PsiModifierListOwner owner) {
        PsiAnnotation.TargetType[] placeTargetTypes = AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList());
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            NullabilityAnnotationInfo result;
            if (element instanceof PsiModifierListOwner && (result = this.getNullityDefault((PsiModifierListOwner)element, placeTargetTypes, false)) != null) {
                return result;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            return this.findNullityDefaultOnPackage(placeTargetTypes, JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName));
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultOnPackage(@NotNull PsiAnnotation.TargetType[] placeTargetTypes, @Nullable PsiPackage psiPackage) {
        boolean superPackage = false;
        while (psiPackage != null) {
            NullabilityAnnotationInfo onPkg = this.getNullityDefault(psiPackage, placeTargetTypes, superPackage);
            if (onPkg != null) {
                return onPkg;
            }
            superPackage = true;
            psiPackage = psiPackage.getParentPackage();
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo getNullityDefault(@NotNull PsiModifierListOwner container, @NotNull PsiAnnotation.TargetType[] placeTargetTypes, boolean superPackage) {
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList == null) {
            return null;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            NullabilityAnnotationInfo result = this.checkNullityDefault(annotation, placeTargetTypes, superPackage);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo checkNullityDefault(@NotNull PsiAnnotation annotation, @NotNull PsiAnnotation.TargetType[] placeTargetTypes, boolean superPackage) {
        NullabilityAnnotationInfo jsr = superPackage ? null : this.isJsr305Default(annotation, placeTargetTypes);
        return jsr != null ? jsr : CheckerFrameworkNullityUtil.isCheckerDefault(annotation, placeTargetTypes);
    }

    @Nullable
    protected abstract NullabilityAnnotationInfo isJsr305Default(@NotNull PsiAnnotation var1, @NotNull PsiAnnotation.TargetType[] var2);

    @NotNull
    public abstract List<String> getNullables();

    @NotNull
    public abstract List<String> getNotNulls();

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        return NullableNotNullManager.getNullability(owner) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        return NullableNotNullManager.getNullability(owner) == Nullability.NOT_NULL;
    }

    @NotNull
    public static Nullability getNullability(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info = NullableNotNullManager.getInstance(owner.getProject()).findEffectiveNullabilityInfo(owner);
        return info == null ? Nullability.UNKNOWN : info.getNullability();
    }

    @NotNull
    public abstract List<String> getInstrumentedNotNulls();

    public abstract void setInstrumentedNotNulls(@NotNull List<String> var1);

    public static boolean isNullableAnnotation(@NotNull PsiAnnotation annotation) {
        return NullableNotNullManager.getInstance(annotation.getProject()).getNullablesWithNickNames().contains(annotation.getQualifiedName());
    }

    public static boolean isNotNullAnnotation(@NotNull PsiAnnotation annotation) {
        return NullableNotNullManager.getInstance(annotation.getProject()).getNotNullsWithNickNames().contains(annotation.getQualifiedName());
    }
}

