/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeCanonicalLookupElement
extends LookupElement {
    private static final Icon EMPTY_ICON = EmptyIcon.create((int)(PlatformIcons.CLASS_ICON.getIconWidth() * 2), (int)PlatformIcons.CLASS_ICON.getIconHeight());
    private final PsiType myType;
    private final String myPresentableText;

    public PsiTypeCanonicalLookupElement(@NotNull PsiType type) {
        this.myType = type;
        this.myPresentableText = this.myType.getPresentableText();
    }

    @NotNull
    public Object getObject() {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null) {
            return psiClass;
        }
        return super.getObject();
    }

    @Nullable
    public PsiClass getPsiClass() {
        return PsiUtil.resolveClassInType(this.myType);
    }

    public boolean isValid() {
        return this.myType.isValid() && super.isValid();
    }

    public PsiType getPsiType() {
        return this.myType;
    }

    @NotNull
    public String getLookupString() {
        return this.myPresentableText;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        context.getEditor().getDocument().replaceString(context.getStartOffset(), context.getStartOffset() + this.getLookupString().length(), (CharSequence)this.getPsiType().getCanonicalText());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiTypeCanonicalLookupElement)) {
            return false;
        }
        PsiTypeCanonicalLookupElement that = (PsiTypeCanonicalLookupElement)((Object)o);
        return this.myType.equals(that.myType);
    }

    public int hashCode() {
        return this.myType.hashCode();
    }

    public void renderElement(LookupElementPresentation presentation) {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null) {
            presentation.setIcon(presentation.isReal() ? psiClass.getIcon(1) : EMPTY_ICON);
            presentation.setTailText(" (" + PsiFormatUtil.getPackageDisplayName(psiClass) + ")", true);
        }
        PsiType type = this.getPsiType();
        presentation.setItemText(type.getPresentableText());
        presentation.setItemTextBold(type instanceof PsiPrimitiveType);
    }
}

