/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@ApiStatus.Experimental
public final class AnalysisUastUtil {
    @Nullable
    public static UCallExpression getUCallExpression(@NotNull PsiElement element) {
        UCallExpression callExpression = UastContextKt.toUElement(element, UCallExpression.class);
        if (callExpression == null) {
            return null;
        }
        if (callExpression.getSourcePsi() != element) {
            return null;
        }
        return callExpression;
    }

    @Nullable
    public static PsiElement getMethodIdentifierSourcePsi(@NotNull UCallExpression callExpression) {
        UIdentifier methodIdentifier = callExpression.getMethodIdentifier();
        if (methodIdentifier == null) {
            return null;
        }
        return methodIdentifier.getSourcePsi();
    }

    @Nullable
    public static String getExpressionReturnTypePsiClassFqn(@NotNull UCallExpression expression) {
        return AnalysisUastUtil.getTypeClassFqn(expression.getReturnType());
    }

    @Nullable
    public static PsiClass getTypePsiClass(@Nullable PsiType type) {
        if (!((type = GenericsUtil.eliminateWildcards(type)) instanceof PsiClassType)) {
            return null;
        }
        return ((PsiClassType)type).rawType().resolve();
    }

    @Nullable
    public static String getExpressionReceiverTypeClassFqn(@NotNull UCallExpression expression) {
        return AnalysisUastUtil.getTypeClassFqn(expression.getReceiverType());
    }

    @Nullable
    public static String getTypeClassFqn(@Nullable PsiType type) {
        if (type == null) {
            return null;
        }
        return type.getCanonicalText().replaceAll("<.*?>", "");
    }

    @Nullable
    public static String getCallableReferenceClassFqn(@NotNull UCallableReferenceExpression expression) {
        String classFqn = AnalysisUastUtil.getTypeClassFqn(expression.getQualifierType());
        if (classFqn != null) {
            return classFqn;
        }
        UExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        if (qualifierExpression instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)qualifierExpression).resolve();
            if (resolved instanceof PsiClass) {
                return ((PsiClass)resolved).getQualifiedName();
            }
            if (resolved instanceof PsiVariable) {
                return AnalysisUastUtil.getTypeClassFqn(((PsiVariable)resolved).getType());
            }
        } else if (qualifierExpression instanceof UThisExpression) {
            return AnalysisUastUtil.getTypeClassFqn(qualifierExpression.getExpressionType());
        }
        return null;
    }

    public static boolean isExpressionResultValueUsed(@NotNull UCallExpression expression) {
        UElement currentParent = expression;
        while ((currentParent = currentParent.getUastParent()) != null) {
            UExpression selector;
            ProgressManager.checkCanceled();
            if (currentParent instanceof UReturnExpression || currentParent instanceof ULocalVariable || currentParent instanceof UField || currentParent instanceof UBinaryExpression || currentParent instanceof UCallExpression) {
                return true;
            }
            if (currentParent instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)currentParent).getSelector()) instanceof UCallExpression && !selector.equals(expression)) {
                return true;
            }
            if (!(currentParent instanceof UMethod) && !(currentParent instanceof UClass) && !(currentParent instanceof UFile)) continue;
        }
        return currentParent instanceof UMethod && !(((UMethod)currentParent).getUastBody() instanceof UBlockExpression);
    }

    public static PsiType getContainingMethodOrLambdaReturnType(UCallExpression expression) {
        for (UElement parent = expression.getUastParent(); parent != null; parent = parent.getUastParent()) {
            if (parent instanceof UMethod) {
                return ((UMethod)parent).getReturnType();
            }
            if (parent instanceof ULambdaExpression) {
                PsiType lambdaType = ((ULambdaExpression)parent).getBody().getExpressionType();
                if (lambdaType != null) {
                    return lambdaType;
                }
                PsiType functionalInterfaceType = ((ULambdaExpression)parent).getFunctionalInterfaceType();
                if (functionalInterfaceType != null) {
                    return LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
                }
                UElement lambdaParent = parent.getUastParent();
                if (lambdaParent instanceof UCallExpression) {
                    PsiParameter lambdaParameter = UastUtils.getParameterForArgument((UCallExpression)lambdaParent, (ULambdaExpression)parent);
                    if (lambdaParameter == null) {
                        return null;
                    }
                    return LambdaUtil.getFunctionalInterfaceReturnType(lambdaParameter.getType());
                }
                return null;
            }
            if (!(parent instanceof UClass)) continue;
            return null;
        }
        return null;
    }
}

