/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.uast.UastMetaLanguage;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UParameter;

public abstract class RefJavaManager
implements RefManagerExtension<RefJavaManager> {
    @NonNls
    public static final String CLASS = "class";
    @NonNls
    public static final String METHOD = "method";
    @NonNls
    static final String IMPLICIT_CONSTRUCTOR = "implicit.constructor";
    @NonNls
    public static final String FIELD = "field";
    @NonNls
    static final String PARAMETER = "parameter";
    @NonNls
    static final String JAVA_MODULE = "java.module";
    @NonNls
    static final String PACKAGE = "package";
    public static final Key<RefJavaManager> MANAGER = Key.create((String)"RefJavaManager");

    public abstract RefImplicitConstructor getImplicitConstructor(String var1);

    public abstract RefPackage getPackage(String var1);

    public abstract RefParameter getParameterReference(UParameter var1, int var2, RefMethod var3);

    public abstract RefPackage getDefaultPackage();

    public abstract PsiMethod getAppMainPattern();

    public abstract PsiMethod getAppPremainPattern();

    public abstract PsiMethod getAppAgentmainPattern();

    public abstract PsiClass getApplet();

    public abstract String getAppletQName();

    public abstract PsiClass getAndroidView();

    public abstract PsiClass getAndroidActivity();

    public abstract PsiClass getAndroidService();

    public abstract PsiClass getAndroidBackupAgent();

    public abstract PsiClass getAndroidContentProvider();

    public abstract PsiClass getAndroidReceiver();

    public abstract PsiClass getAndroidFragment(boolean var1);

    public abstract PsiClass getAndroidActionProvider();

    public abstract PsiClass getAndroidParcelable();

    public abstract String getServletQName();

    public abstract EntryPointsManager getEntryPointsManager();

    @NotNull
    public Collection<Language> getLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>(((UastMetaLanguage)Language.findInstance(UastMetaLanguage.class)).getMatchingLanguages());
        languages.removeIf(l -> l.isKindOf("Groovy"));
        if (!Registry.is((String)"batch.jvm.inspections") && !ApplicationManager.getApplication().isUnitTestMode()) {
            languages.removeIf(l -> l.isKindOf("kotlin"));
        }
        return languages;
    }

    @NotNull
    public Language getLanguage() {
        return JavaLanguage.INSTANCE;
    }

    @NotNull
    public Key<RefJavaManager> getID() {
        return MANAGER;
    }
}

