/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RemoteRepositoryDescription {
    public static final RemoteRepositoryDescription MAVEN_CENTRAL = new RemoteRepositoryDescription("central", "Maven Central repository", "https://repo1.maven.org/maven2");
    public static final RemoteRepositoryDescription JBOSS_COMMUNITY = new RemoteRepositoryDescription("jboss.community", "JBoss Community repository", "https://repository.jboss.org/nexus/content/repositories/public/");
    public static final List<RemoteRepositoryDescription> DEFAULT_REPOSITORIES = Arrays.asList(MAVEN_CENTRAL, JBOSS_COMMUNITY);
    private final String myId;
    private final String myName;
    private final String myUrl;

    public RemoteRepositoryDescription(@NotNull String id, @NotNull String name, @NotNull String url) {
        this.myId = id;
        this.myName = name;
        this.myUrl = url;
    }

    public String getId() {
        return this.myId;
    }

    public String getName() {
        return this.myName;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRepositoryDescription that = (RemoteRepositoryDescription)o;
        if (!this.myId.equals(that.myId)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myUrl.equals(that.myUrl);
    }

    public int hashCode() {
        int result = this.myId.hashCode();
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myUrl.hashCode();
        return result;
    }

    public String toString() {
        return this.myId + ":" + this.myName + ":" + this.myUrl;
    }
}

