/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm;

import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.JvmField;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmTypeDeclaration;
import com.intellij.lang.jvm.JvmTypeParametersOwner;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.lang.jvm.util.JvmClassDefaults;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JvmClass
extends JvmTypeParametersOwner,
JvmTypeDeclaration {
    @Override
    @Nullable
    @NonNls
    public String getName();

    @Nullable
    @NonNls
    public String getQualifiedName();

    @NotNull
    public JvmClassKind getClassKind();

    @Nullable
    public JvmReferenceType getSuperClassType();

    @NotNull
    public JvmReferenceType[] getInterfaceTypes();

    @NotNull
    public JvmMethod[] getMethods();

    @NotNull
    default public JvmMethod[] findMethodsByName(@NotNull String methodName) {
        return JvmClassDefaults.findMethodsByName(this, methodName);
    }

    @NotNull
    public JvmField[] getFields();

    @NotNull
    public JvmClass[] getInnerClasses();

    @Override
    default public <T> T accept(@NotNull JvmElementVisitor<T> visitor) {
        return visitor.visitClass(this);
    }
}

