/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.jvm.JvmLanguage;
import com.intellij.lang.jvm.source.JvmDeclarationSearcher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class JvmMetaLanguage
extends MetaLanguage {
    private static final Logger LOG = Logger.getInstance(JvmMetaLanguage.class);
    private final Set<String> supportedLanguages;

    protected JvmMetaLanguage() {
        super("JVM");
        ExtensionsArea rootArea = Extensions.getRootArea();
        if (rootArea.hasExtensionPoint(JvmDeclarationSearcher.EP.getName())) {
            ExtensionPoint jvmDeclarationSearcherEP = rootArea.getExtensionPoint(JvmDeclarationSearcher.EP.getName());
            LanguageExtensionPoint[] jvmDeclarationSearcherImplementations = (LanguageExtensionPoint[])jvmDeclarationSearcherEP.getExtensions();
            this.supportedLanguages = Collections.unmodifiableSet(Arrays.stream(jvmDeclarationSearcherImplementations).map(ep -> ep.getKey()).collect(Collectors.toSet()));
        } else {
            this.supportedLanguages = Collections.emptySet();
            LOG.warn("'JvmMetaLanguage' requested but no implementations of 'JvmDeclarationSearcher' EP were found in the 'rootArea'");
        }
    }

    public boolean matchesLanguage(@NotNull Language language) {
        return language instanceof JvmLanguage || this.supportedLanguages.contains(language.getID());
    }
}

