/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.source;

import com.intellij.lang.jvm.JvmElement;
import com.intellij.lang.jvm.source.JvmDeclarationSearcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.FlatteningIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmDeclarationSearch {
    private JvmDeclarationSearch() {
    }

    @NotNull
    public static Iterable<JvmElement> getElementsByIdentifier(@NotNull PsiElement identifierElement) {
        PsiElement declaringElement = JvmDeclarationSearch.findDeclaringElement(identifierElement);
        if (declaringElement == null) {
            return Collections.emptyList();
        }
        return () -> JvmDeclarationSearch.iterateDeclarations(declaringElement);
    }

    @Nullable
    private static PsiElement findDeclaringElement(@NotNull PsiElement potentiallyIdentifyingElement) {
        PsiElement parent = potentiallyIdentifyingElement.getParent();
        if (parent instanceof PsiNameIdentifierOwner && ((PsiNameIdentifierOwner)parent).getIdentifyingElement() == potentiallyIdentifyingElement) {
            return parent;
        }
        return null;
    }

    @NotNull
    private static Iterator<JvmElement> iterateDeclarations(@NotNull PsiElement declaringElement) {
        List searchers = JvmDeclarationSearcher.EP.allForLanguage(declaringElement.getLanguage());
        return searchers.isEmpty() ? EmptyIterator.getInstance() : JvmDeclarationSearch.iterateDeclarations(declaringElement, searchers);
    }

    @NotNull
    private static Iterator<JvmElement> iterateDeclarations(final @NotNull PsiElement declaringElement, @NotNull Collection<JvmDeclarationSearcher> searchers) {
        return new FlatteningIterator<JvmDeclarationSearcher, JvmElement>(searchers.iterator()){

            public boolean hasNext() {
                ProgressManager.checkCanceled();
                return super.hasNext();
            }

            protected Iterator<JvmElement> createValueIterator(JvmDeclarationSearcher searcher) {
                return searcher.findDeclarations(declaringElement).iterator();
            }
        };
    }

    @NotNull
    public static Iterable<JvmElement> getImmediatelyContainingElements(@NotNull PsiElement place) {
        List extensions2 = JvmDeclarationSearcher.EP.allForLanguage(place.getLanguage());
        if (extensions2.isEmpty()) {
            return Collections.emptyList();
        }
        for (PsiElement current = place; current != null; current = current.getParent()) {
            Iterator<JvmElement> iterator = JvmDeclarationSearch.iterateDeclarations(current, extensions2);
            if (!iterator.hasNext()) continue;
            return () -> iterator;
        }
        return Collections.emptyList();
    }
}

