/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.types;

import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JvmPrimitiveTypeKind {
    public static final JvmPrimitiveTypeKind BOOLEAN = new JvmPrimitiveTypeKind("boolean", "java.lang.Boolean", "Z");
    public static final JvmPrimitiveTypeKind BYTE = new JvmPrimitiveTypeKind("byte", "java.lang.Byte", "B");
    public static final JvmPrimitiveTypeKind CHAR = new JvmPrimitiveTypeKind("char", "java.lang.Character", "C");
    public static final JvmPrimitiveTypeKind DOUBLE = new JvmPrimitiveTypeKind("double", "java.lang.Double", "D");
    public static final JvmPrimitiveTypeKind FLOAT = new JvmPrimitiveTypeKind("float", "java.lang.Float", "F");
    public static final JvmPrimitiveTypeKind INT = new JvmPrimitiveTypeKind("int", "java.lang.Integer", "I");
    public static final JvmPrimitiveTypeKind LONG = new JvmPrimitiveTypeKind("long", "java.lang.Long", "J");
    public static final JvmPrimitiveTypeKind SHORT = new JvmPrimitiveTypeKind("short", "java.lang.Short", "S");
    public static final JvmPrimitiveTypeKind VOID = new JvmPrimitiveTypeKind("void", "java.lang.Void", "V");
    private final String myName;
    private final String myBoxedFqn;
    private final String myBinaryName;
    private static final Map<String, JvmPrimitiveTypeKind> ourNameToKind;
    private static final Map<String, JvmPrimitiveTypeKind> ourFqnToKind;

    private JvmPrimitiveTypeKind(String name, String boxedFqn, String binaryName) {
        this.myName = name;
        this.myBoxedFqn = boxedFqn;
        this.myBinaryName = binaryName;
    }

    @Contract(pure=true)
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Contract(pure=true)
    @NotNull
    public String getBoxedFqn() {
        return this.myBoxedFqn;
    }

    @Contract(pure=true)
    @NotNull
    public String getBinaryName() {
        return this.myBinaryName;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static JvmPrimitiveTypeKind getKindByName(@Nullable String name) {
        return ourNameToKind.get(name);
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static JvmPrimitiveTypeKind getKindByFqn(@Nullable String fqn) {
        return ourFqnToKind.get(fqn);
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<String> getBoxedFqns() {
        return Collections.unmodifiableCollection(ourFqnToKind.keySet());
    }

    static {
        JvmPrimitiveTypeKind[] values = new JvmPrimitiveTypeKind[]{BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, VOID};
        THashMap nameToKind = new THashMap();
        THashMap fqnToKind = new THashMap();
        for (JvmPrimitiveTypeKind kind : values) {
            nameToKind.put((Object)kind.getName(), (Object)kind);
            fqnToKind.put((Object)kind.getBoxedFqn(), (Object)kind);
        }
        nameToKind.compact();
        fqnToKind.compact();
        ourNameToKind = nameToKind;
        ourFqnToKind = fqnToKind;
    }
}

