/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.util;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.types.JvmArrayType;
import com.intellij.lang.jvm.types.JvmPrimitiveType;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.lang.jvm.util.JvmHierarchyUtil;
import com.intellij.lang.jvm.util.JvmUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmMainMethodUtil {
    private static final String MAIN = "main";

    private JvmMainMethodUtil() {
    }

    public static boolean isMainMethod(@NotNull JvmMethod method) {
        if (!MAIN.equals(method.getName())) {
            return false;
        }
        JvmClass containingClass = method.getContainingClass();
        return containingClass != null && JvmMainMethodUtil.canBeMainClass(containingClass) && JvmMainMethodUtil.hasMainMethodSignature(method);
    }

    public static boolean hasMainMethodInHierarchy(@NotNull JvmClass clazz) {
        if (!JvmMainMethodUtil.canBeMainClass(clazz)) {
            return false;
        }
        return JvmMainMethodUtil.findMainMethodInHierarchy(clazz) != null;
    }

    private static boolean canBeMainClass(@NotNull JvmClass clazz) {
        if (clazz.getName() == null) {
            return false;
        }
        JvmClassKind kind = clazz.getClassKind();
        if (kind == JvmClassKind.ANNOTATION) {
            return false;
        }
        return clazz.getContainingClass() == null || clazz.hasModifier(JvmModifier.STATIC);
    }

    @Nullable
    private static JvmMethod findMainMethodInHierarchy(@NotNull JvmClass clazz) {
        return JvmHierarchyUtil.traverseSupers(clazz, JvmMainMethodUtil::findMainMethodInClass);
    }

    @Nullable
    private static JvmMethod findMainMethodInClass(@NotNull JvmClass clazz) {
        Object[] candidates = clazz.findMethodsByName(MAIN);
        return (JvmMethod)ContainerUtil.find((Object[])candidates, JvmMainMethodUtil::hasMainMethodSignature);
    }

    private static boolean hasMainMethodSignature(@NotNull JvmMethod method) {
        if (method.isConstructor()) {
            return false;
        }
        if (!method.hasModifier(JvmModifier.PUBLIC)) {
            return false;
        }
        if (!method.hasModifier(JvmModifier.STATIC)) {
            return false;
        }
        JvmType returnType = Objects.requireNonNull(method.getReturnType(), () -> "Non-constructors should have return type: " + method);
        if (!JvmMainMethodUtil.isVoid(returnType)) {
            return false;
        }
        JvmParameter[] parameters = method.getParameters();
        if (parameters.length != 1) {
            return false;
        }
        return JvmMainMethodUtil.isStringArray(parameters[0].getType());
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isVoid(@NotNull JvmType type) {
        return type instanceof JvmPrimitiveType && ((JvmPrimitiveType)type).getKind() == JvmPrimitiveTypeKind.VOID;
    }

    private static boolean isStringArray(@NotNull JvmType type) {
        if (!(type instanceof JvmArrayType)) {
            return false;
        }
        JvmType componentType = ((JvmArrayType)type).getComponentType();
        if (!(componentType instanceof JvmReferenceType)) {
            return false;
        }
        JvmClass resolved = JvmUtil.resolveClass((JvmReferenceType)componentType);
        return resolved != null && "java.lang.String".equals(resolved.getQualifiedName());
    }
}

