/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jvm.util;

import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmTypeDeclaration;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmUtil {
    private static final JvmModifier[] ACCESS_MODIFIERS = new JvmModifier[]{JvmModifier.PRIVATE, JvmModifier.PACKAGE_LOCAL, JvmModifier.PROTECTED, JvmModifier.PUBLIC};

    private JvmUtil() {
    }

    @NotNull
    static Iterable<JvmClass> resolveClasses(@NotNull JvmReferenceType[] types) {
        return ContainerUtil.mapNotNull((Object[])types, JvmUtil::resolveClass);
    }

    @Contract(value="null -> null")
    @Nullable
    public static JvmClass resolveClass(@Nullable JvmReferenceType type) {
        if (type == null) {
            return null;
        }
        JvmTypeDeclaration resolved = type.resolve();
        return resolved instanceof JvmClass ? (JvmClass)resolved : null;
    }

    @PsiModifier.ModifierConstant
    @NotNull
    public static JvmModifier getAccessModifier(@PsiUtil.AccessLevel int accessLevel) {
        assert (accessLevel > 0 && accessLevel <= ACCESS_MODIFIERS.length) : accessLevel;
        return ACCESS_MODIFIERS[accessLevel - 1];
    }
}

