/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JavaSdkVersion {
    JDK_1_0(LanguageLevel.JDK_1_3),
    JDK_1_1(LanguageLevel.JDK_1_3),
    JDK_1_2(LanguageLevel.JDK_1_3),
    JDK_1_3(LanguageLevel.JDK_1_3),
    JDK_1_4(LanguageLevel.JDK_1_4),
    JDK_1_5(LanguageLevel.JDK_1_5),
    JDK_1_6(LanguageLevel.JDK_1_6),
    JDK_1_7(LanguageLevel.JDK_1_7),
    JDK_1_8(LanguageLevel.JDK_1_8),
    JDK_1_9(LanguageLevel.JDK_1_9),
    JDK_10(LanguageLevel.JDK_10),
    JDK_11(LanguageLevel.JDK_11),
    JDK_12(LanguageLevel.JDK_12);

    private final LanguageLevel myMaxLanguageLevel;

    private JavaSdkVersion(LanguageLevel maxLanguageLevel) {
        this.myMaxLanguageLevel = maxLanguageLevel;
    }

    @NotNull
    public LanguageLevel getMaxLanguageLevel() {
        return this.myMaxLanguageLevel;
    }

    @NotNull
    public String getDescription() {
        int feature = this.ordinal();
        return feature < 5 ? "1." + feature : String.valueOf(feature);
    }

    public boolean isAtLeast(@NotNull JavaSdkVersion version) {
        return this.compareTo(version) >= 0;
    }

    @NotNull
    public static JavaSdkVersion fromLanguageLevel(@NotNull LanguageLevel languageLevel) throws IllegalArgumentException {
        JavaSdkVersion[] values = JavaSdkVersion.values();
        if (languageLevel == LanguageLevel.JDK_X) {
            return values[values.length - 1];
        }
        int feature = languageLevel.toJavaVersion().feature;
        if (feature < values.length) {
            return values[feature];
        }
        throw new IllegalArgumentException("Can't map " + (Object)((Object)languageLevel) + " to any of " + Arrays.toString((Object[])values));
    }

    @Nullable
    public static JavaSdkVersion fromVersionString(@NotNull String versionString) {
        JavaVersion version = JavaVersion.tryParse((String)versionString);
        return version != null ? JavaSdkVersion.fromJavaVersion(version) : null;
    }

    @Nullable
    public static JavaSdkVersion fromJavaVersion(@NotNull JavaVersion version) {
        JavaSdkVersion[] values = JavaSdkVersion.values();
        return version.feature < values.length ? values[version.feature] : null;
    }
}

