/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVersionService {
    public static JavaVersionService getInstance() {
        return (JavaVersionService)ServiceManager.getService(JavaVersionService.class);
    }

    public boolean isAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion version) {
        return PsiUtil.getLanguageLevel(element).isAtLeast(version.getMaxLanguageLevel());
    }

    @Nullable
    public JavaSdkVersion getJavaSdkVersion(@NotNull PsiElement element) {
        return JavaSdkVersion.fromLanguageLevel(PsiUtil.getLanguageLevel(element));
    }

    public boolean isCompilerVersionAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion version) {
        return this.isAtLeast(element, version);
    }
}

