/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiMethodPattern
extends PsiMemberPattern<PsiMethod, PsiMethodPattern> {
    public PsiMethodPattern() {
        super(PsiMethod.class);
    }

    public PsiMethodPattern withParameterCount(final @NonNls int paramCount) {
        return (PsiMethodPattern)this.with((PatternCondition)new PatternCondition<PsiMethod>("withParameterCount"){

            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                return method.getParameterList().getParametersCount() == paramCount;
            }
        });
    }

    public PsiMethodPattern withParameters(String ... inputTypes) {
        final String[] types = inputTypes.length == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : inputTypes;
        return (PsiMethodPattern)this.with((PatternCondition)new PatternCondition<PsiMethod>("withParameters"){

            public boolean accepts(@NotNull PsiMethod psiMethod, ProcessingContext context) {
                PsiParameterList parameterList = psiMethod.getParameterList();
                int dotsIndex = -1;
                while (++dotsIndex < types.length && !Comparing.equal((String)"..", (String)types[dotsIndex])) {
                }
                if (dotsIndex == types.length && parameterList.getParametersCount() != dotsIndex || dotsIndex < types.length && parameterList.getParametersCount() < dotsIndex) {
                    return false;
                }
                if (dotsIndex > 0) {
                    PsiParameter[] psiParameters = parameterList.getParameters();
                    for (int i = 0; i < dotsIndex; ++i) {
                        if (Comparing.equal((String)"?", (String)types[i]) || this.typeEquivalent(psiParameters[i].getType(), types[i])) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean typeEquivalent(PsiType type, String expectedText) {
                PsiType erasure = TypeConversionUtil.erasure(type);
                return erasure != null && erasure.equalsToText(expectedText);
            }
        });
    }

    @NotNull
    public PsiMethodPattern definedInClass(@NonNls String qname) {
        return this.definedInClass((ElementPattern<? extends PsiClass>)PsiJavaPatterns.psiClass().withQualifiedName(qname));
    }

    @NotNull
    public PsiMethodPattern definedInClass(ElementPattern<? extends PsiClass> pattern) {
        return (PsiMethodPattern)this.with((PatternCondition)new PatternConditionPlus<PsiMethod, PsiClass>("definedInClass", pattern){

            public boolean processValues(PsiMethod t, ProcessingContext context, PairProcessor<PsiClass, ProcessingContext> processor) {
                if (!processor.process((Object)t.getContainingClass(), (Object)context)) {
                    return false;
                }
                Ref result = Ref.create((Object)Boolean.TRUE);
                SuperMethodsSearch.search(t, null, true, false).forEach(signature -> {
                    if (!processor.process((Object)signature.getMethod().getContainingClass(), (Object)context)) {
                        result.set((Object)Boolean.FALSE);
                        return false;
                    }
                    return true;
                });
                return (Boolean)result.get();
            }
        });
    }

    public PsiMethodPattern constructor(final boolean isConstructor) {
        return (PsiMethodPattern)this.with((PatternCondition)new PatternCondition<PsiMethod>("constructor"){

            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                return method.isConstructor() == isConstructor;
            }
        });
    }

    public PsiMethodPattern withThrowsList(final ElementPattern<?> pattern) {
        return (PsiMethodPattern)this.with((PatternCondition)new PatternCondition<PsiMethod>("withThrowsList"){

            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                return pattern.accepts((Object)method.getThrowsList());
            }
        });
    }
}

