/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Key;
import com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    JDK_1_3(JavaCoreBundle.message("jdk.1.3.language.level.description", new Object[0]), 3),
    JDK_1_4(JavaCoreBundle.message("jdk.1.4.language.level.description", new Object[0]), 4),
    JDK_1_5(JavaCoreBundle.message("jdk.1.5.language.level.description", new Object[0]), 5),
    JDK_1_6(JavaCoreBundle.message("jdk.1.6.language.level.description", new Object[0]), 6),
    JDK_1_7(JavaCoreBundle.message("jdk.1.7.language.level.description", new Object[0]), 7),
    JDK_1_8(JavaCoreBundle.message("jdk.1.8.language.level.description", new Object[0]), 8),
    JDK_1_9(JavaCoreBundle.message("jdk.1.9.language.level.description", new Object[0]), 9),
    JDK_10(JavaCoreBundle.message("jdk.10.language.level.description", new Object[0]), 10),
    JDK_11(JavaCoreBundle.message("jdk.11.language.level.description", new Object[0]), 11),
    JDK_12(JavaCoreBundle.message("jdk.12.language.level.description", new Object[0]), 12),
    JDK_12_PREVIEW(JavaCoreBundle.message("jdk.12.preview.language.level.description", new Object[0]), 12),
    JDK_X(JavaCoreBundle.message("jdk.X.language.level.description", new Object[0]), 12);

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    private final String myPresentableText;
    private final JavaVersion myVersion;
    private final boolean myPreview;

    private LanguageLevel(String presentableText, int major) {
        this.myPresentableText = presentableText;
        this.myVersion = JavaVersion.compose((int)major);
        this.myPreview = this.name().endsWith("_PREVIEW");
    }

    public boolean isPreview() {
        return this.myPreview;
    }

    @NotNull
    @Nls
    public String getPresentableText() {
        return this.myPresentableText;
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        return this.compareTo(level) >= 0;
    }

    public boolean isLessThan(@NotNull LanguageLevel level) {
        return this.compareTo(level) < 0;
    }

    @NotNull
    public JavaVersion toJavaVersion() {
        return this.myVersion;
    }

    @Deprecated
    public String getCompilerComplianceDefaultOption() {
        return this.myVersion.feature <= 8 ? "1." + this.myVersion.feature : String.valueOf(this.myVersion.feature);
    }

    @Nullable
    public static LanguageLevel parse(@Nullable String compilerComplianceOption) {
        JavaSdkVersion sdkVersion;
        if (compilerComplianceOption != null && (sdkVersion = JavaSdkVersion.fromVersionString(compilerComplianceOption)) != null) {
            return sdkVersion.getMaxLanguageLevel();
        }
        return null;
    }

    static {
        HIGHEST = JDK_12;
        KEY = Key.create((String)"LANGUAGE_LEVEL");
    }
}

