/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface JavaModuleSystem {
    public static final ExtensionPointName<JavaModuleSystem> EP_NAME = new ExtensionPointName("com.intellij.javaModuleSystem");

    @NotNull
    public String getName();

    default public boolean isAccessible(@NotNull PsiClass target, @NotNull PsiElement place) {
        PsiFile targetFile = target.getContainingFile();
        if (targetFile == null) {
            return true;
        }
        PsiUtilCore.ensureValid((PsiElement)targetFile);
        String packageName = PsiUtil.getPackageName(target);
        return packageName == null || this.isAccessible(packageName, targetFile, place);
    }

    public boolean isAccessible(@NotNull String var1, @Nullable PsiFile var2, @NotNull PsiElement var3);
}

